/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.reconciliation.entryeditor;

import au.com.ordermate.gui.actions.BasicAction;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import officemate.screens.reports.reconciliation.entryeditor.AbstractEntryEditor;
import ordermate.database.finance.reconciliation.AbstractReconciliationEntry;
import ordermate.database.finance.reconciliation.CashdrawerReconciliation;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.binding.BindingHelper;
import org.jdesktop.swingx.VerticalLayout;

public abstract class DeletableEntryEditor
extends AbstractEntryEditor {
    private JPanel deletableEntries = new JPanel();
    private AbstractReconciliationEntry entry;
    protected BindingHelper controlBindingHelper;

    public abstract JComponent createControlPanel();

    public DeletableEntryEditor() {
        FieldPanelBuilder builder = this.getFieldPanelBuilder();
        builder.addSeparator("");
        JPanel topPanel = builder.getPanel();
        this.setLayout(new BoxLayout(this, 1));
        this.deletableEntries.setLayout((LayoutManager)new VerticalLayout());
        JScrollPane scrollPane = new JScrollPane(this.deletableEntries, 20, 31);
        scrollPane.setPreferredSize(new Dimension(80, 210));
        this.add(topPanel);
        this.add(scrollPane);
        this.add(this.createControlPanel());
    }

    @Override
    public void setCashdrawerReconciliation(CashdrawerReconciliation reconciliation) {
        super.setCashdrawerReconciliation(reconciliation);
        this.deletableEntries.removeAll();
        this.deletableEntries.validate();
        this.setEntry(this.createNewEntry());
    }

    protected void addDeletableEntry(AbstractReconciliationEntry anEntry) {
        JPanel entryPanel = new JPanel();
        JButton deleteButton = new JButton((Action)((Object)new DeleteAction(anEntry)));
        JLabel label = new JLabel(anEntry.getLabel());
        label.setLabelFor(deleteButton);
        entryPanel.add(label);
        entryPanel.add(deleteButton);
        this.deletableEntries.add(entryPanel);
        this.validate();
    }

    protected AbstractReconciliationEntry getEntry() {
        this.controlBindingHelper.saveObject();
        return this.entry;
    }

    protected void setEntry(AbstractReconciliationEntry theEntry) {
        this.entry = theEntry;
        this.controlBindingHelper.setObject((Object)this.entry);
    }

    protected abstract AbstractReconciliationEntry createNewEntry();

    protected class AddAction
    extends BasicAction {
        public AddAction() {
            super("Add");
        }

        public void actionPerformed(ActionEvent e) {
            DeletableEntryEditor.this.getCashDrawerReconciliation().addEntry(DeletableEntryEditor.this.getEntry());
            DeletableEntryEditor.this.addDeletableEntry(DeletableEntryEditor.this.getEntry());
            DeletableEntryEditor.this.setEntry(DeletableEntryEditor.this.createNewEntry());
        }
    }

    private class DeleteAction
    extends BasicAction {
        private AbstractReconciliationEntry deletableEntry;

        public DeleteAction(AbstractReconciliationEntry theEntry) {
            super("Delete");
            this.deletableEntry = theEntry;
        }

        public void actionPerformed(ActionEvent e) {
            DeletableEntryEditor.this.getCashDrawerReconciliation().removeEntry(this.deletableEntry);
            DeletableEntryEditor.this.deletableEntries.remove(((Component)e.getSource()).getParent());
            DeletableEntryEditor.this.deletableEntries.validate();
            DeletableEntryEditor.this.deletableEntries.repaint();
        }
    }
}

