/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.reconciliation.entryeditor;

import au.com.ordermate.persistence.PropertiedObject;
import java.awt.Component;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import officemate.OfficeMate;
import officemate.screens.reports.reconciliation.entryeditor.DeletableEntryEditor;
import ordermate.database.finance.reconciliation.AbstractReconciliationEntry;
import ordermate.database.finance.reconciliation.CashdrawerReconciliation;
import ordermate.database.finance.reconciliation.entries.PettyCashEntry;
import ordermate.database.users.User;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.binding.BindingHelper;
import ordermate.gui.binding.validators.NotEmptyValidator;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.Validator;

public class PettyCashEntryEditor
extends DeletableEntryEditor {
    private static final String EXPENSE_TOOL_TIP = "An Expense is an item that the business has bought and will then use (for example, a light globe or a roll of paper).";
    private static final String PURCHASE_TOOL_TIP = "A Purchase is an item that has purchased and will then be sold to a customer (for example, bread or milk).";
    private JRadioButton expenseButton;
    private JRadioButton purchaseButton;
    private JButton addButton;

    @Override
    public void setCashdrawerReconciliation(CashdrawerReconciliation recon) {
        super.setCashdrawerReconciliation(recon);
        Iterator it = recon.getPettyCashEntries().iterator();
        while (it.hasNext()) {
            this.addDeletableEntry((AbstractReconciliationEntry)((PettyCashEntry)it.next()));
        }
    }

    @Override
    public JComponent createControlPanel() {
        FieldPanelBuilder builder = new FieldPanelBuilder();
        this.controlBindingHelper = new BindingHelper(AutoBinding.UpdateStrategy.READ_WRITE);
        ButtonGroup group = new ButtonGroup();
        this.expenseButton = new JRadioButton();
        this.purchaseButton = new JRadioButton();
        this.expenseButton.setSelected(true);
        group.add(this.expenseButton);
        group.add(this.purchaseButton);
        builder.addRow("Expense", (Component)this.expenseButton, EXPENSE_TOOL_TIP);
        builder.addRow("Purchase", (Component)this.purchaseButton, PURCHASE_TOOL_TIP);
        this.controlBindingHelper.createBinding(PettyCashEntry.Properties.PURCHASE, (Object)this.purchaseButton, "selected");
        JTextField descriptionField = new JTextField(21);
        Binding descriptionBinding = this.controlBindingHelper.createBinding(PettyCashEntry.Properties.DESCRIPTION, (Object)descriptionField, "text");
        descriptionBinding.setValidator((Validator)new NotEmptyValidator());
        JComboBox<Object> userField = new JComboBox<Object>(User.getUsers().toArray());
        Binding userBinding = this.controlBindingHelper.createBinding(PettyCashEntry.Properties.USER, userField, "selectedItem");
        builder.addRow("User", userField);
        builder.addRow("Description", (Component)descriptionField);
        this.addValueField("Amount", builder, this.controlBindingHelper);
        DeletableEntryEditor.AddAction action = new DeletableEntryEditor.AddAction();
        this.controlBindingHelper.addValidatedAction((Action)((Object)action));
        this.addButton = new JButton((Action)((Object)action));
        builder.addRow("", (Component)this.addButton);
        return builder.getPanel();
    }

    @Override
    protected PropertiedObject.Property getKeyProperty() {
        return CashdrawerReconciliation.Properties.PETTY_CASH_TOTAL;
    }

    @Override
    protected AbstractReconciliationEntry createNewEntry() {
        PettyCashEntry entry = new PettyCashEntry();
        entry.setUser(OfficeMate.getInstance().getEventContext().getUser());
        return entry;
    }

    @Override
    public JButton getDefaultButton() {
        return this.addButton;
    }
}

