/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.reconciliation.entryeditor;

import au.com.ordermate.persistence.PropertiedObject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import officemate.screens.reports.reconciliation.entryeditor.AbstractEntryEditor;
import ordermate.database.finance.reconciliation.CashdrawerReconciliation;
import ordermate.database.finance.reconciliation.entries.WebEntry;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.binding.converter.Converters;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.Property;

public class WebEntryEditor
extends AbstractEntryEditor {
    private HashMap<FinanceUnit, JTextComponent> unitTypeFieldMap = new HashMap();
    private List<Binding> unitBindings = new ArrayList<Binding>();

    public WebEntryEditor() {
        FieldPanelBuilder builder = this.getFieldPanelBuilder();
        List units = FinanceUnit.getWebUnits();
        for (FinanceUnit currentUnit : units) {
            builder.addRow(currentUnit.getLabel() + " (" + currentUnit.getType() + ")", this.getEntryField(currentUnit));
        }
        this.add(builder.getPanel());
    }

    @Override
    protected PropertiedObject.Property getKeyProperty() {
        return CashdrawerReconciliation.Properties.WEB_TOTAL;
    }

    @Override
    public void setCashdrawerReconciliation(CashdrawerReconciliation recon) {
        super.setCashdrawerReconciliation(recon);
        for (Binding binding : this.unitBindings) {
            binding.unbind();
        }
        this.unitBindings.clear();
        for (FinanceUnit key : this.unitTypeFieldMap.keySet()) {
            WebEntry entry = this.getCashDrawerReconciliation().getWebEntry(key);
            JTextComponent field = this.unitTypeFieldMap.get(key);
            AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)entry, (Property)BeanProperty.create((String)WebEntry.Properties.VALUE.getName()), (Object)field, (Property)BeanProperty.create((String)"text"));
            binding.setConverter((Converter)Converters.PRICE_TO_STRING);
            binding.bind();
            this.unitBindings.add((Binding)binding);
        }
    }

    @Override
    public void saveObject() {
        super.saveObject();
        Iterator<Binding> it = this.unitBindings.iterator();
        while (it.hasNext()) {
            it.next().save();
        }
    }

    private Component getEntryField(FinanceUnit financeUnit) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JTextField field = new JTextField(10);
        field.setName(financeUnit.getLabel());
        this.unitTypeFieldMap.put(financeUnit, field);
        panel.add(field);
        return panel;
    }
}

