/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.reconciliation.pettycash;

import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.searchfield.java.ComboSearchField;
import au.com.ordermate.search.searchfield.java.DateRangeSearchField;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import au.com.ordermate.util.DateTimeUtils;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.text.Format;
import java.util.Collection;
import java.util.Date;
import javax.swing.Action;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.search.ObjectPropertySearch;
import officemate.components.table.AbstractTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import ordermate.database.finance.reconciliation.entries.PettyCashEntry;
import ordermate.database.misc.ConfigShift;
import ordermate.database.reports.reconciliation.pettycash.PettyCashSearcher;
import ordermate.database.users.AllPermissions;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class PettyCashReportTableState
extends AbstractTableState<PettyCashEntry> {
    private DateRangeSearchField dateField;
    private ComboSearchField shiftField;
    private PettyCashSearcher searcher = new PettyCashSearcher();

    public PettyCashReportTableState() {
        super("Petty Cash Entries", AllPermissions.ACCESS_USER_REPORTS, "Access and view your Petty Cash Entries");
    }

    @Override
    protected TableStateCentralArea<PettyCashEntry> createCentralArea() {
        ColumnTableFormat format = new ColumnTableFormat();
        format.addColumn((ColumnFormat)new PropertyColumnFormat(PettyCashEntry.Properties.PURCHASE));
        format.addColumn((ColumnFormat)new PropertyColumnFormat(PettyCashEntry.Properties.CREATED, (Format)DateTimeUtils.getConsistentReportFormat()));
        format.addColumn((ColumnFormat)new PropertyColumnFormat((PropertiedObject.Property)PettyCashEntry.Properties.SHIFT));
        format.addColumn((ColumnFormat)new PropertyColumnFormat(PettyCashEntry.Properties.USER));
        format.addColumn((ColumnFormat)new PropertyColumnFormat(PettyCashEntry.Properties.DESCRIPTION));
        format.addColumn((ColumnFormat)new PropertyColumnFormat(PettyCashEntry.Properties.VALUE));
        PersistentObjectTable<PettyCashEntry> table = new PersistentObjectTable<PettyCashEntry>(this.getObjectList(), format);
        return table;
    }

    @Override
    protected Class<PettyCashEntry> getDisplayingType() {
        return PettyCashEntry.class;
    }

    @Override
    protected OfficeMateObjectSearch<PettyCashEntry> createSearchPanelFactory() {
        ObjectPropertySearch<PettyCashEntry> search = new ObjectPropertySearch<PettyCashEntry>(PettyCashEntry.class, (ObjectQuerySearcher<PettyCashEntry>)this.searcher, (EventList<PettyCashEntry>)new BasicEventList());
        RefreshAction refresh = new RefreshAction((Refreshable)this);
        this.dateField = new DateRangeSearchField("Date", (IRangedQuerySearchFilter)this.searcher.getDateRangeFilter(), new Date(), (Action)refresh);
        this.shiftField = new ComboSearchField("Shift", (ISingleValueSearchFilter)this.searcher.getShiftFilter(), true, (Action)refresh, GlazedLists.eventList((Collection)ConfigShift.getAllConfigShifts()));
        search.addSearchField((SearchGuiField)this.dateField);
        search.addSearchField((SearchGuiField)this.shiftField);
        return search;
    }

    PettyCashSearcher getSearcher() {
        return this.searcher;
    }
}

