/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.refunds;

import au.com.ordermate.glazedlists.GlazedListUtils;
import au.com.ordermate.gui.renderer.JCheckBoxCellRenderer;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.oquery.search.filter.implementation.FixedRangeSearchFilter;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.propertyaccessor.PropertyAccessor;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.search.SearchFilterI;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.searchfield.java.ComboSearchField;
import au.com.ordermate.search.searchfield.java.DateRangeSearchField;
import au.com.ordermate.search.searchfield.java.MultiSelectComboSearchField;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.OffsetFunction;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.swing.Action;
import officemate.adminkit.state.SearchGuiState;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.search.ObjectPropertySearch;
import officemate.components.search.searchfield.TimeRangeSearchField;
import officemate.components.table.AbstractTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.reports.RefundsReport;
import ordermate.database.searchers.reports.RefundsReportSearcher;
import ordermate.database.users.User;
import ordermate.reports.dynamicjasper.PeriodReportAdapter;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class RefundReportSearchState
extends AbstractTableState<RefundsReport>
implements SearchGuiState<RefundsReport> {
    private final RefundsReportSearcher searcher;
    private RefreshAction refreshAction = new RefreshAction((Refreshable)this);
    private final EventList usersList = GlazedLists.eventList((Collection)User.getUsers());
    private EventList<Date> dates;

    public RefundReportSearchState(RefundsReportSearcher rrSearcher) {
        super("Search", null, "Select Refunds to report on");
        this.searcher = rrSearcher;
    }

    public RefundsReportSearcher getSearcher() {
        return this.searcher;
    }

    @Override
    protected TableStateCentralArea<RefundsReport> createCentralArea() {
        return new PersistentObjectTable<RefundsReport>(this.getObjectList(), new ColumnTableFormat(new ColumnFormat[]{new PropertyColumnFormat("User", (PropertiedObject.Property)RefundsReport.Properties.USER_NAME), new PropertyColumnFormat("Creation Time", (PropertyAccessor)RefundsReport.Properties.CREATION_TIME, (Format)DateTimeUtils.getConsistentReportFormat()), new PropertyColumnFormat("Sales Item", RefundsReport.Properties.SALES_ITEM), new PropertyColumnFormat("Portion", RefundsReport.Properties.PORTION), new PropertyColumnFormat(RefundsReport.Properties.QUANTITY), new PropertyColumnFormat("Total", (PropertiedObject.Property)RefundsReport.Properties.TOTAL)}));
    }

    @Override
    protected Class<RefundsReport> getDisplayingType() {
        return RefundsReport.class;
    }

    @Override
    public void refresh() {
        super.refresh();
        PeriodReportAdapter periodAdapter = this.searcher.getPeriod();
        if (periodAdapter != null) {
            GlazedListUtils.setAsList(this.dates, new ArrayList(periodAdapter.getDateList()));
        }
    }

    @Override
    protected OfficeMateObjectSearch createSearchPanelFactory() {
        ObjectPropertySearch<RefundsReport> search = new ObjectPropertySearch<RefundsReport>(RefundsReport.class, (ObjectQuerySearcher<RefundsReport>)this.getSearcher(), (EventList<RefundsReport>)new BasicEventList());
        PeriodReportAdapter periodAdapter = this.searcher.getPeriod();
        if (periodAdapter == null) {
            search.addSearchField((SearchGuiField)new DateRangeSearchField("Date Range", this.searcher.getTradingDayDateRangeFilter(), DateTimeUtils.getOneMonthAgoCal().getTime(), (Action)this.refreshAction));
        } else {
            this.dates = GlazedLists.eventList((Collection)periodAdapter.getDateList());
            FixedRangeSearchFilter searchProp = this.searcher.getFixedRangeFilter();
            searchProp.setOffsetFunction((OffsetFunction)periodAdapter.getDateOffset());
            this.searcher.addSearchFilter((SearchFilterI)searchProp);
            search.addSearchField((SearchGuiField)new ComboSearchField(periodAdapter.getLabel(), (ISingleValueSearchFilter)searchProp, false, (Action)this.refreshAction, this.dates, (Format)periodAdapter.getFormatter()));
        }
        search.addSearchField((SearchGuiField)new MultiSelectComboSearchField("User", (Action)this.refreshAction, this.usersList, null, this.searcher.getUserSearchFilter(), new JCheckBoxCellRenderer()));
        search.addSearchField(new TimeRangeSearchField(this.getSearcher().getTimeFilter(), (Action)this.refreshAction));
        search.addSearchField((SearchGuiField)new MultiSelectComboSearchField("Sales Location", this.searcher.getSalesLocationFilter(), (Action)this.refreshAction, GlazedLists.eventList((Collection)SalesLocation.getSalesLocations())));
        return search;
    }
}

