/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.salesbyarea;

import au.com.ordermate.util.FormatStringifier;
import au.com.ordermate.util.Stringifier;
import java.text.Format;
import java.text.NumberFormat;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import officemate.adminkit.table.ShadeAlternateRowsTableCellRenderer;
import ordermate.database.reports.sales.byarea.SalesByAreaCompiler;
import ordermate.database.reports.sales.byarea.SalesByAreaSearcher;

public class SalesByAreaTable
extends JTable {
    private JScrollPane scroller;
    private SalesByAreaCompiler compiler;
    private ShadeAlternateRowsTableCellRenderer renderer;
    private final NumberFormat percentageFormatter;

    public SalesByAreaTable(SalesByAreaSearcher searcher) {
        this.compiler = new SalesByAreaCompiler(searcher);
        this.renderer = new ShadeAlternateRowsTableCellRenderer();
        this.setSelectionMode(0);
        this.setDefaultRenderer(String.class, this.renderer);
        this.scroller = new JScrollPane(this, 20, 30);
        this.percentageFormatter = NumberFormat.getPercentInstance();
        this.percentageFormatter.setMinimumFractionDigits(1);
        this.percentageFormatter.setMaximumFractionDigits(2);
    }

    @Override
    public boolean isCellEditable(int r, int c) {
        return false;
    }

    public void updateSearch() {
        this.setTableHeader(new JTableHeader(this.getColumnModel()));
        this.setModel(this.compiler.compile());
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        String currentColName = this.getColumnName(column);
        if ("Stock Area".equals(currentColName) || "Category".equals(currentColName)) {
            return this.renderer;
        }
        if ("GP %".equals(currentColName)) {
            this.renderer.setStringifier((Stringifier)new FormatStringifier((Format)this.percentageFormatter, Double.class));
            return this.renderer;
        }
        this.renderer.setStringifier((Stringifier)new FormatStringifier((Format)NumberFormat.getCurrencyInstance(), Double.class));
        return this.renderer;
    }

    public JScrollPane getScroller() {
        return this.scroller;
    }
}

