/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.salesbyarea;

import au.com.ordermate.application.ApplicationContext;
import au.com.ordermate.util.MathsUtils;
import au.com.ordermate.util.Price;
import java.sql.ResultSet;
import java.sql.SQLException;
import officemate.adminkit.table.QueryTableModel;

public class SalesByAreaTableModel
extends QueryTableModel {
    private ApplicationContext context;

    public SalesByAreaTableModel(String selQuery, int idField, int[] colsToDisplay, String[] colDisplayNames, ApplicationContext dbContext) {
        super(selQuery, dbContext.getDatabaseConnection(), idField, colsToDisplay, colDisplayNames);
        this.context = dbContext;
    }

    @Override
    protected Object getTableValue(int row, int col, String colName, int dbColIndex, ResultSet rs) throws SQLException {
        try {
            if (dbColIndex == 0 || dbColIndex == 1 || dbColIndex == 2 || dbColIndex == 3) {
                double priceVal = rs.getDouble(colName);
                return new Price(priceVal, 0.01);
            }
            if (dbColIndex == 4) {
                double val = rs.getDouble(colName);
                return new Double(MathsUtils.roundDoubleToDecPlaces((double)val, (int)2));
            }
        }
        catch (SQLException e) {
            this.context.getLog().error("Cannot access table.", (Throwable)e);
            return null;
        }
        return super.getTableValue(row, col, colName, dbColIndex, rs);
    }
}

