/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.salesbydaypart;

import au.com.ordermate.notify.Notifiable;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.searchfield.java.DateRangeSearchField;
import au.com.ordermate.search.searchfield.java.MultiSelectComboSearchField;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Date;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import officemate.components.search.AbstractObjectSearch;
import officemate.components.search.SearchBarPanel;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.reports.sales.bydaypart.SalesByDayPartReportHelper;
import ordermate.database.reports.sales.bydaypart.SalesByDayPartReportParams;
import ordermate.database.searchers.reports.sales.bydaypart.AbstractSalesByDayPartSearcher;

public class SalesByDayPartSearch
extends AbstractObjectSearch<String>
implements ActionListener,
Notifiable<SalesByDayPartReportParams> {
    private final RefreshAction refresh;
    private final AbstractSalesByDayPartSearcher searcher;
    private DateRangeSearchField dateRangeField;
    private MultiSelectComboSearchField salesLocationsField;
    private JCheckBox includeTaxField;

    public SalesByDayPartSearch(AbstractSalesByDayPartSearcher searcher, RefreshAction refresh) {
        super(new BasicEventList());
        this.searcher = searcher;
        this.refresh = refresh;
    }

    @Override
    public void addToSearchPanel(JComponent comp) {
        this.getSearchPanel().add(comp);
    }

    @Override
    public void resetSearch() {
    }

    @Override
    public void reaquireSearchOptions() {
    }

    @Override
    protected JPanel createSearchPanel() {
        SearchBarPanel search = new SearchBarPanel();
        this.dateRangeField = new DateRangeSearchField(" ", this.searcher.getDateRangeFilter(), new Date(), (Action)this.refresh);
        this.dateRangeField.useFixedDates();
        this.dateRangeField.getDateRangePanel().getStartPicker().setName("SBDP_" + this.searcher.getSalesObjectName() + "_startDate");
        this.dateRangeField.getDateRangePanel().getEndPicker().setName("SBDP_" + this.searcher.getSalesObjectName() + "_endDate");
        this.salesLocationsField = new MultiSelectComboSearchField("Sales Location", this.searcher.getSalesLocationFilter(), (Action)this.refresh, GlazedLists.eventList((Collection)SalesLocation.getSalesLocations()));
        this.includeTaxField = new JCheckBox("Tax Inclusive", false);
        this.includeTaxField.setHorizontalTextPosition(2);
        this.includeTaxField.setSelected(false);
        this.includeTaxField.addActionListener(this);
        search.addSearchField((SearchGuiField)this.dateRangeField);
        search.addSearchField((SearchGuiField)this.salesLocationsField);
        search.addSearchField("", this.includeTaxField);
        return search;
    }

    @Override
    protected void doRefresh() {
        this.dateRangeField.getSearchProperty().setStart((Comparable)this.dateRangeField.getDateRangePanel().getStartDate());
        this.dateRangeField.getSearchProperty().setEnd((Comparable)this.dateRangeField.getDateRangePanel().getEndDate());
        this.searcher.setIncludeTax(this.includeTaxField.isSelected());
        SalesByDayPartReportParams params = new SalesByDayPartReportParams((Date)this.searcher.getDateRangeFilter().getStart(), (Date)this.searcher.getDateRangeFilter().getEnd(), this.searcher.isIncludeTax());
        SalesByDayPartReportHelper.INSTANCE.getBus().notifySubscribers((Object)params);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.includeTaxField) {
            this.searcher.setIncludeTax(this.includeTaxField.isSelected());
            this.refresh.doRefresh();
        }
    }

    public void notified(SalesByDayPartReportParams params) {
        if (params.getStartDate() != null) {
            this.dateRangeField.getDateRangePanel().setStartDate(params.getStartDate());
        }
        if (params.getEndDate() != null) {
            this.dateRangeField.getDateRangePanel().setEndDate(params.getEndDate());
        }
        this.includeTaxField.setSelected(params.isTaxInclusive());
    }
}

