/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.saleshistory;

import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.search.SearchFilterI;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.offset.DateOffsetFunction;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import java.awt.Component;
import java.util.Date;
import javax.swing.Action;
import officemate.components.controls.ComboDateRangePanel;
import ordermate.reports.dynamicjasper.PeriodReportAdapter;

public class ComboDateRangeSearchField
extends SearchGuiField {
    private ComboDateRangePanel comboDateRangePanel;
    private IRangedQuerySearchFilter<Date> filter;
    private DateOffsetFunction offset;

    public ComboDateRangeSearchField(IRangedQuerySearchFilter<Date> filter, PeriodReportAdapter period, RefreshAction refreshAction) {
        super("Dates", (Action)refreshAction);
        if (filter == null || period == null) {
            throw new IllegalArgumentException("The filter and period must not be null");
        }
        this.filter = filter;
        this.offset = period.getDateOffset();
        Date start = this.getStartOfCurrentPeriod();
        this.comboDateRangePanel = new ComboDateRangePanel(start, new Date(), period, filter, refreshAction);
        this.comboDateRangePanel.addAction((Action)refreshAction);
    }

    private Date getStartOfCurrentPeriod() {
        Date start;
        if (this.filter.hasSearchValue() && this.filter.getStart() != null) {
            start = new Date();
            start = (Date)this.filter.getStart();
        } else {
            start = this.offset.calcStart(new Date());
        }
        return start;
    }

    public Component getGuiComponent() {
        return this.comboDateRangePanel;
    }

    public void addAction(Action action) {
        if (this.comboDateRangePanel != null) {
            this.comboDateRangePanel.addAction(action);
        }
    }

    public void reset() {
        this.comboDateRangePanel.refresh();
        this.comboDateRangePanel.setStartDate(this.getStartOfCurrentPeriod());
        this.comboDateRangePanel.setEndDate(new Date());
    }

    public SearchFilterI getSearchProperty() {
        this.comboDateRangePanel.refresh();
        if (!this.isEnabled()) {
            this.filter.setStart(null);
            this.filter.setEnd(null);
        }
        return this.filter;
    }

    public void setVisible(boolean flag) {
        this.getGuiComponent().setVisible(flag);
    }

    public boolean isVisible() {
        return this.getGuiComponent().isVisible();
    }

    public void setEnabled(boolean flag) {
        this.getGuiComponent().setEnabled(flag);
        if (!flag) {
            this.filter.setStart(null);
            this.filter.setEnd(null);
        }
    }

    public boolean isEnabled() {
        return this.getGuiComponent().isEnabled();
    }
}

