/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.sata;

import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.searchfield.java.DateRangeSearchField;
import au.com.ordermate.util.DateTimeUtils;
import ca.odell.glazedlists.BasicEventList;
import java.util.Date;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import officemate.components.search.AbstractObjectSearch;
import officemate.components.search.SearchBarPanel;
import ordermate.database.filters.OptimisedDateRangeSearchFilter;
import ordermate.database.reports.sata.SATAReport;
import ordermate.database.reports.sata.SATAReportCompiler;
import ordermate.database.sales.SalesItemQuantity;

class SATASearch
extends AbstractObjectSearch<SATAReport> {
    private SATAReportCompiler compiler = SATAReportCompiler.getMonthCompiler((Date)new Date());
    private DateRangeSearchField customDateField;
    private RefreshAction refresh;

    public SATASearch(RefreshAction yourRefresh) {
        super(new BasicEventList());
        this.refresh = yourRefresh;
    }

    public SATAReportCompiler getCompiler() {
        return this.compiler;
    }

    @Override
    public void addToSearchPanel(JComponent comp) {
        ((SearchBarPanel)this.getSearchPanel()).add(comp);
    }

    @Override
    public void resetSearch() {
    }

    @Override
    public void reaquireSearchOptions() {
    }

    @Override
    protected JPanel createSearchPanel() {
        SearchBarPanel searchBar = new SearchBarPanel();
        this.customDateField = new DateRangeSearchField("Range", (IRangedQuerySearchFilter)new OptimisedDateRangeSearchFilter(SalesItemQuantity.Properties.CREATION_TIME, SQLDateType.TIMESTAMP), DateTimeUtils.getOneMonthAgoCal().getTime(), (Action)this.refresh);
        this.customDateField.useFixedDates();
        searchBar.addSearchField("", this.customDateField.getGuiComponent());
        return searchBar;
    }

    @Override
    protected void doRefresh() {
        this.compiler.setDateRange((Date)this.customDateField.getSearchProperty().getStart(), (Date)this.customDateField.getSearchProperty().getEnd());
        this.compiler.clearCache();
        this.compiler.performReport();
    }
}

