/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.staff;

import au.com.ordermate.gui.renderer.JCheckBoxCellRenderer;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.searchfield.java.ComboSearchField;
import au.com.ordermate.search.searchfield.java.DateRangeSearchField;
import au.com.ordermate.search.searchfield.java.MultiSelectComboSearchField;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import javax.swing.Action;
import javax.swing.JPanel;
import officemate.components.search.ObjectPropertySearch;
import officemate.components.search.reports.PeriodAdaptable;
import officemate.components.search.reports.PeriodAdaptableSelector;
import officemate.components.search.reports.PeriodReportConfiguration;
import officemate.components.search.reports.PeriodReportConfigurationFactory;
import officemate.components.search.searchfield.TimeRangeSearchField;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.misc.ConfigShift;
import ordermate.database.reports.sales.staff.AbstractStaffSoldReport;
import ordermate.database.searchers.reports.sales.staff.AbstractStaffSoldReportSearcher;
import ordermate.database.users.User;
import ordermate.reports.dynamicjasper.PeriodReportAdapter;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public abstract class AbstractStaffSoldReportSearch<T extends AbstractStaffSoldReport>
extends ObjectPropertySearch<T>
implements PeriodAdaptable {
    public final Signal<PeriodReportAdapter, ?, ?, ?, ?> periodSignal = Signals.createSignal(PeriodReportAdapter.class, (String)"newPeriod");
    private PeriodAdaptableSelector periodSelector;
    private ComboSearchField dateComboField;
    private DateRangeSearchField dateRangeField;
    private TimeRangeSearchField timeField;
    private MultiSelectComboSearchField userField;
    private MultiSelectComboSearchField salesLocationsField;
    private EventList<User> users;
    private PeriodReportConfiguration configuration;

    public AbstractStaffSoldReportSearch(Class<T> objClassToSearch, ObjectQuerySearcher<T> newSearcher, EventList<T> eventObjectList) {
        super(objClassToSearch, newSearcher, eventObjectList);
        this.init();
        this.useSearchRefreshStrategy();
    }

    public AbstractStaffSoldReportSearcher<T> getSearcher() {
        return (AbstractStaffSoldReportSearcher)this.getPropertySearcher();
    }

    protected void init() {
        RefreshAction refresh = new RefreshAction((Refreshable)this);
        refresh.setEnabled(false);
        this.periodSelector = new PeriodAdaptableSelector(this.getPeriods());
        this.periodSelector.setPeriodAdaptable(this);
        JPanel holder = new JPanel();
        holder.add(this.periodSelector);
        this.addToSearchPanel(holder);
        AbstractStaffSoldReportSearcher<T> searcher = this.getSearcher();
        this.dateRangeField = new DateRangeSearchField("Date Range", searcher.getTradingDayDateRangeFilter(), new Date(), (Action)refresh);
        this.addSearchField((SearchGuiField)this.dateRangeField);
        this.dateComboField = new ComboSearchField("Start Date", (ISingleValueSearchFilter)searcher.getFixedRangeFilter(), false, (Action)refresh, GlazedLists.eventList(Collections.singletonList(new Date())));
        this.addSearchField((SearchGuiField)new MultiSelectComboSearchField("Shift", (Action)refresh, GlazedLists.eventList((Collection)ConfigShift.getAllConfigShifts()), null, (MultiOptionSearchFilter)searcher.getShiftFilter(), new JCheckBoxCellRenderer()));
        this.timeField = new TimeRangeSearchField(searcher.getTimeFilter(), (Action)refresh);
        this.addSearchField(this.timeField);
        refresh.setEnabled(false);
        this.users = GlazedLists.eventList((Collection)User.getUsers());
        this.userField = new MultiSelectComboSearchField("User", (Action)refresh, this.users, null, searcher.getUserFilter(), new JCheckBoxCellRenderer());
        this.addSearchField((SearchGuiField)this.userField);
        this.salesLocationsField = new MultiSelectComboSearchField("Sales Location", searcher.getSalesLocationFilter(), (Action)refresh, GlazedLists.eventList((Collection)SalesLocation.getSalesLocations()));
        this.addSearchField((SearchGuiField)this.salesLocationsField);
        this.addCustomSearchFields(refresh);
        refresh.setEnabled(true);
    }

    private PeriodReportAdapter[] getPeriods() {
        ArrayList adapters = new ArrayList();
        Collections.addAll(adapters, PeriodReportAdapter.getStandardPeriods());
        adapters.add(0, null);
        return adapters.toArray(new PeriodReportAdapter[0]);
    }

    protected abstract void addCustomSearchFields(RefreshAction var1);

    @Override
    public void adaptToPeriod(PeriodReportAdapter adapter) {
        this.dateComboField.reset();
        this.configuration = PeriodReportConfigurationFactory.getConfigurationFor(adapter);
        this.dateComboField.setVisible(this.configuration != null);
        this.getSearcher().getFixedRangeFilter().clearSearch();
        this.getSearcher().getTradingDayDateRangeFilter().clearSearch();
        this.removeSearchField((SearchGuiField)this.dateRangeField);
        this.removeSearchField((SearchGuiField)this.dateComboField);
        if (this.configuration != null) {
            this.addSearchField(0, (SearchGuiField)this.dateComboField);
            EventList<Date> dates = this.configuration.getComboDates();
            this.dateComboField.setListData(dates);
            this.dateComboField.setSelectedObject(dates.get(0));
            this.dateComboField.setFormat((Format)this.configuration.constructFormatter());
            this.getSearcher().getFixedRangeFilter().setOffsetFunction(this.configuration.getDateOffset());
            this.getSearcher().getFixedRangeFilter().setSearchValue((Comparable)dates.get(0));
        } else {
            this.addSearchField(0, (SearchGuiField)this.dateRangeField);
        }
        this.layoutSearchPanel();
        this.getSearchPanel().validate();
        this.getSearchPanel().repaint();
        this.periodSignal.emit((Object)adapter);
    }
}

