/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.stockhistory;

import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.searchfield.java.ComboSearchField;
import au.com.ordermate.search.searchfield.java.DateRangeSearchField;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import au.com.ordermate.util.DateTimeUtils;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import javax.swing.Action;
import officemate.components.search.ObjectPropertySearch;
import ordermate.database.reports.stock.StockItemPriceReport;
import ordermate.database.reports.stock.StockItemPriceReportSearcher;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.StockSupplier;

public class StockPriceHistorySearchControl
extends ObjectPropertySearch<StockItemPriceReport> {
    private DateRangeSearchField dateRange;
    private ComboSearchField stockCombo;
    private ComboSearchField supplierCombo;
    private EventList<StockItem> stockItems;
    private EventList<StockSupplier> suppliers;

    public StockPriceHistorySearchControl(StockItemPriceReportSearcher searcher) {
        super(StockItemPriceReport.class, searcher, new BasicEventList());
        RefreshAction refresh = new RefreshAction((Refreshable)this);
        Calendar cal = Calendar.getInstance();
        DateTimeUtils.clearTimePart((Calendar)cal);
        cal.set(2, 0);
        cal.set(5, 1);
        cal.set(1, 2001);
        this.dateRange = new DateRangeSearchField("Date Range", (IRangedQuerySearchFilter)searcher.getDateRangeFilter(), cal.getTime(), (Action)refresh);
        this.dateRange.getDateRangePanel().setEndDate(new Date());
        this.addSearchField((SearchGuiField)this.dateRange);
        this.stockItems = GlazedLists.eventList((Collection)PersistenceManager.getObjectList(StockItem.class, (String)Query.select(StockItem.class).active(StockItem.class).orderBy(StockItem.Properties.LABEL).toString()));
        this.stockCombo = new ComboSearchField("Stock Item", searcher.getStockFilter(), false, (Action)refresh, this.stockItems);
        this.addSearchField((SearchGuiField)this.stockCombo);
        this.suppliers = GlazedLists.eventList((Collection)PersistenceManager.getObjectList(StockSupplier.class, (String)Query.select(StockSupplier.class).active(StockSupplier.class).orderBy(StockSupplier.Properties.LABEL).toString()));
        this.supplierCombo = new ComboSearchField("Supplier", searcher.getSupplierFilter(), true, (Action)refresh, this.suppliers);
        this.addSearchField((SearchGuiField)this.supplierCombo);
        this.reaquireSearchOptions();
    }
}

