/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.stockonhand;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.guicore.task.AbstractGuiTask;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.DateDMY;
import au.com.ordermate.util.FormatStringifier;
import au.com.ordermate.util.GuiUtils;
import au.com.ordermate.util.Stringifier;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Format;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import officemate.adminkit.ObjectChangeRecorder;
import officemate.adminkit.ObjectEditorPanel;
import officemate.adminkit.ObjectTemplate;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.dialogs.ObjectEditorDialog;
import officemate.adminkit.print.Printing;
import officemate.adminkit.search.SearchDialog;
import officemate.adminkit.searchpanels.StockItemSearchPanel;
import officemate.adminkit.state.ActionFactory;
import officemate.adminkit.state.BasicOfficeMateState;
import officemate.adminkit.table.GroupedTable;
import officemate.adminkit.table.GroupedTableCellRenderer;
import officemate.adminkit.table.GroupedTableModel;
import officemate.adminkit.table.LinkedTotalTable;
import officemate.adminkit.table.PriceGroupedTableModel;
import officemate.adminkit.table.QueryTable;
import officemate.adminkit.table.QueryTableModel;
import officemate.adminkit.table.ShadeAlternateRowsTableCellRenderer;
import officemate.adminkit.templates.Templates;
import officemate.adminkit.tree.stockgroup.StockGroupTreePanel;
import officemate.screens.ObjectManagerI;
import officemate.screens.reports.stockonhand.StockOnHandTableModel;
import ordermate.database.misc.StockControlEventLog;
import ordermate.database.queries.stock.StockOnHandQueries;
import ordermate.database.reports.stock.onhand.StockOnHandSearcher;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockGroup;
import ordermate.database.stock.StockItem;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.User;

public class StockOnHandState
extends BasicOfficeMateState {
    private JPanel innerPanel = new JPanel(new BorderLayout());
    private JPanel northPanel;
    private JPanel northWestPanel;
    private JPanel tablePanel;
    private JPanel eastPanel;
    private JSplitPane splitter;
    private StockGroupTreePanel treePanel = null;
    private LinkedTotalTable totalsTable;
    private GroupedTable groupedTable;
    private JCheckBox groupedCheck;
    private boolean groupResults = true;
    private final StockOnHandSearcher searcher;
    private QueryTable table;
    private QueryTableModel tableModel;
    private JComboBox areasCombo;
    private boolean alreadySetup = false;
    private boolean updatesAllowed = true;

    public StockOnHandState() {
        super("Stock On Hand", AllPermissions.ACCESS_STOCK_ON_HAND_REPORT, "Show Stock On Hand");
        this.innerPanel.setName("Stock On Hand");
        this.setScreenPanel(this.innerPanel);
        this.addAction((Action)ActionFactory.createPermissibleEditAction(this, AllPermissions.EDIT_STOCK_ITEMS));
        this.searcher = new StockOnHandSearcher();
    }

    @Override
    protected void onStart() {
        GuiApp.getAppComplex().getApplicationFrame().setStatusBarText("Loading SOH Report screen...");
        if (!this.alreadySetup) {
            this.alreadySetup = Dialogs.showProgressDialog((AbstractTask)new StockOnHandSetupTask());
            if (!this.alreadySetup) {
                Dialogs.showErrorDialog("Error Loading Screen", "Please contact OrderMate Support");
                return;
            }
        } else {
            this.refresh();
        }
        GuiApp.getAppComplex().getApplicationFrame().resetStatusBarText();
    }

    @Override
    protected void onEnd() {
    }

    private void setupGUI() {
        this.splitter = new JSplitPane();
        this.innerPanel.add((Component)this.splitter, "Center");
        this.eastPanel = new JPanel(new BorderLayout());
        this.northPanel = new JPanel(new BorderLayout());
        this.northWestPanel = new JPanel(new FlowLayout());
        this.tablePanel = new JPanel(new BorderLayout());
        JPanel addRemoveWrapper = new JPanel(new BorderLayout());
        this.eastPanel.add((Component)this.tablePanel, "Center");
        this.eastPanel.add((Component)addRemoveWrapper, "East");
        this.splitter.setRightComponent(this.eastPanel);
        this.northPanel.add((Component)this.northWestPanel, "West");
        this.innerPanel.add((Component)this.northPanel, "North");
    }

    private void setupAreasCombo() {
        this.areasCombo = new JComboBox<Object>(StockArea.getStockAreas().toArray());
        this.areasCombo.setName("areasCombo");
        this.areasCombo.insertItemAt("(All)", 0);
        this.areasCombo.setSelectedIndex(0);
        OfficeMateAdminGuiUtils.getInstance().standardComboSetup(this.areasCombo);
        this.areasCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StockOnHandState.this.updatesAllowed) {
                    StockOnHandState.this.refresh();
                }
            }
        });
        this.northWestPanel.add(new JLabel("Areas: "));
        this.northWestPanel.add(this.areasCombo);
    }

    private void setupGroupCheck() {
        this.groupedCheck = new JCheckBox("Group results", this.groupResults);
        this.northWestPanel.add(this.groupedCheck);
        this.groupedCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StockOnHandState.this.groupResults = StockOnHandState.this.groupedCheck.isSelected();
                StockOnHandState.this.refresh();
            }
        });
    }

    private void setupTree() {
        this.treePanel = new StockGroupTreePanel(((ObjectManagerI)GuiApp.getAppComplex().getApplicationContext()).getObjectManager());
        this.treePanel.objectSelected.connect((Object)this, "gotTreeObjectSelected");
        this.splitter.setLeftComponent(this.treePanel);
    }

    private void setupTable() {
        String[] displayColumns = StockOnHandQueries.Reports.DISPLAY_COLUMNS;
        int[] colsToShow = StockOnHandQueries.Reports.COLUMNS_TO_SHOW;
        this.tableModel = new StockOnHandTableModel(StockOnHandQueries.Reports.GetStockOnHandDetail.getQuery(null, null, null).getSQL(), GuiApp.getAppComplex().getApplicationContext().getDatabaseConnection(), 1, colsToShow, displayColumns);
        this.tableModel.addTotalResultSetColumn(7);
        this.tableModel.addTotalResultSetColumn(9);
        this.table = new QueryTable(this.tableModel);
        OfficeMateAdminGuiUtils.getInstance().standardTableSetup(this.table);
        ShadeAlternateRowsTableCellRenderer renderer = new ShadeAlternateRowsTableCellRenderer();
        renderer.setStringifier((Stringifier)new FormatStringifier((Format)NumberFormat.getCurrencyInstance(), Double.class));
        this.table.getColumn(displayColumns[3]).setCellRenderer(renderer);
        this.table.getColumn(displayColumns[4]).setCellRenderer(renderer);
        this.table.getColumn(displayColumns[5]).setCellRenderer(renderer);
        this.table.getColumn(displayColumns[6]).setCellRenderer(renderer);
        this.table.objectSelected.connect((Object)this, "gotTableObjectSelected");
        this.table.objectChosen.connect((Object)this, "doEditAction");
        this.tablePanel.add((Component)this.table.getScroller(), "Center");
        this.splitter.setDividerLocation(160);
    }

    private void updateButtonState() {
        boolean validRowSelected = false;
        if (this.groupResults) {
            GroupedTableModel groupedModel = this.groupedTable.getGroupedTableModel();
            int selectedRow = this.groupedTable.getSelectedRow();
            if (selectedRow >= 0 && selectedRow < this.groupedTable.getRowCount() && !groupedModel.isTitleRow(selectedRow) && !groupedModel.isTotalRow(selectedRow)) {
                validRowSelected = true;
            }
        } else {
            int selectedRow = this.table.getSelectedRow();
            if (selectedRow >= 0 && selectedRow < this.table.getRowCount()) {
                validRowSelected = true;
            }
        }
        this.toggleDefaultAction(this.getEditAction(), validRowSelected);
    }

    private GroupedTable getNewGroupedTable() {
        if (this.groupedTable != null) {
            this.groupedTable.objectChosen.disconnect((Object)this);
            this.groupedTable.objectSelected.disconnect((Object)this);
        }
        PriceGroupedTableModel model = new PriceGroupedTableModel((AbstractTableModel)this.table.getModel(), "Group", new String[]{StockOnHandQueries.Reports.DISPLAYLABEL_TOTAL_INC, StockOnHandQueries.Reports.DISPLAYLABEL_TOTAL_EX});
        this.groupedTable = new GroupedTable(model);
        OfficeMateAdminGuiUtils.getInstance().standardTableSetup((JTable)((Object)this.groupedTable));
        this.groupedTable.objectChosen.connect((Object)this, "gotGroupedTableObjectChosen");
        this.groupedTable.objectSelected.connect((Object)this, "gotTableObjectSelected");
        GroupedTableCellRenderer renderer = new GroupedTableCellRenderer();
        renderer.setStringifier((FormatStringifier<Double>)new FormatStringifier((Format)NumberFormat.getCurrencyInstance(), Double.class));
        this.groupedTable.getColumn(2).setCellRenderer(renderer);
        this.groupedTable.getColumn(3).setCellRenderer(renderer);
        this.groupedTable.getColumn(4).setCellRenderer(renderer);
        this.groupedTable.getColumn(5).setCellRenderer(renderer);
        return this.groupedTable;
    }

    private Number[] getCorrectTotals(Number[] theNormalTotals) {
        Number[] normalTotals = theNormalTotals;
        if (this.groupResults) {
            int titleColumn = this.tableModel.findColumn("Group");
            Number[] newTotals = new Number[normalTotals.length - 1];
            int write = 0;
            for (int read = 0; read < normalTotals.length; ++read) {
                if (read == titleColumn) continue;
                newTotals[write++] = normalTotals[read];
            }
            normalTotals = newTotals;
        }
        return normalTotals;
    }

    public JTable getActiveTable() {
        return this.groupResults ? this.groupedTable : this.table;
    }

    private void setupTotalsPanel() {
        if (this.tablePanel != null && this.totalsTable != null) {
            this.tablePanel.remove(this.totalsTable);
        }
        this.totalsTable = new LinkedTotalTable(this.getActiveTable().getColumnModel());
        this.totalsTable.setName("Totals");
        this.tablePanel.add((Component)this.totalsTable, "South");
        Number[] totals = this.tableModel.getTotals();
        this.totalsTable.setColumnValues(this.getCorrectTotals(totals));
    }

    private StockGroup getCurrentStockGroup() {
        Object obj = this.treePanel.getSelectedObject();
        return obj instanceof StockGroup ? (StockGroup)obj : null;
    }

    private StockArea getCurrentStockArea() {
        Object obj = this.areasCombo.getSelectedItem();
        return obj instanceof StockArea ? (StockArea)obj : null;
    }

    public void updateQuery(StockGroup group, StockArea area) {
        if (group != null) {
            ArrayList<StockGroup> groups = null;
            List subGroups = group.getRecursiveSubGroups();
            groups = new ArrayList<StockGroup>(subGroups.size() + 1);
            groups.add(group);
            groups.addAll(subGroups);
            this.searcher.getGroupFilter().setSearchValue(groups);
        } else {
            this.searcher.getGroupFilter().setSearchValue(null);
        }
        this.searcher.getAreaFilter().setSearchValue((Object)area);
        this.searcher.getGroupedFilter().setSearchValue((Object)this.groupResults);
        this.tableModel.setQuery(this.searcher.getQuery());
        this.table.updateModel();
        this.table.revalidate();
        this.tablePanel.remove(this.table.getScroller());
        if (this.groupedTable != null) {
            this.tablePanel.remove(this.groupedTable.getScroller());
        }
        if (this.groupResults) {
            this.tablePanel.add((Component)this.getNewGroupedTable().getScroller(), "Center");
        } else {
            this.tablePanel.add((Component)this.table.getScroller(), "Center");
        }
        this.setupTotalsPanel();
        this.tablePanel.revalidate();
        this.tablePanel.repaint();
        this.totalsTable.repaint();
    }

    @Override
    public boolean supportsRefresh() {
        return true;
    }

    @Override
    public boolean supportsSearch() {
        return true;
    }

    @Override
    public boolean supportsPrint() {
        return true;
    }

    @Override
    public void doRefreshAction() {
        this.refresh();
    }

    @Override
    public void refresh() {
        this.updatesAllowed = false;
        if (this.treePanel != null) {
            Object selGroup = this.treePanel.getSelectedObject();
            this.treePanel.refresh();
            this.treePanel.getTree().setSelectedObject(selGroup);
        }
        Long selectedID = OfficeMateAdminGuiUtils.getInstance().getSelectedID(this.table, this.groupResults ? this.groupedTable : null);
        int selectedTableRow = OfficeMateAdminGuiUtils.getInstance().getSelectedTableRow(this.table, this.groupResults ? this.groupedTable : null);
        if (this.areasCombo != null) {
            Object comboSelected = this.areasCombo.getSelectedItem();
            this.areasCombo.setModel(new DefaultComboBoxModel<Object>(StockArea.getStockAreas().toArray()));
            this.areasCombo.insertItemAt("(All)", 0);
            this.areasCombo.setSelectedIndex(0);
            this.areasCombo.setSelectedItem(comboSelected);
            this.updateQuery(this.getCurrentStockGroup(), this.getCurrentStockArea());
            OfficeMateAdminGuiUtils.getInstance().selectIfPossible(this.table, this.groupResults ? this.groupedTable : null, selectedID, selectedTableRow);
            this.updateButtonState();
        }
        this.updatesAllowed = true;
    }

    @Override
    public void doSearchAction() {
        StockItemSearchPanel searchPanel = new StockItemSearchPanel();
        Long id = SearchDialog.search(GuiApp.getAppComplex().getApplicationFrame().getFrame(), searchPanel, "Find Stock Item...");
        if (id != null) {
            JScrollPane scrollerToUse;
            Object tableToUse;
            int tableRow;
            this.treePanel.getTree().setSelectedObject(null);
            int originalRow = this.table.getQueryTableModel().getRow(id);
            if (this.groupResults) {
                tableRow = this.groupedTable.getGroupedTableModel().getGroupedRow(originalRow);
                this.groupedTable.setRowSelectionInterval(tableRow, tableRow);
                tableToUse = this.groupedTable;
                scrollerToUse = this.groupedTable.getScroller();
            } else {
                tableRow = originalRow;
                this.table.setRowSelectionInterval(tableRow, tableRow);
                tableToUse = this.table;
                scrollerToUse = this.table.getScroller();
            }
            if (tableRow >= 0) {
                GuiUtils.scrollToTableRow((JScrollPane)scrollerToUse, (JTable)tableToUse, (int)tableRow);
                ((JComponent)tableToUse).revalidate();
                ((Component)tableToUse).repaint();
            } else {
                JOptionPane.showMessageDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), "Couldn't find stock item \"" + PersistenceManager.getByID((long)id, StockItem.class) + "\" in the " + this.getCurrentStockArea() + " area.", "Couldn't find item", 2);
            }
        }
    }

    @Override
    public void doEditAction() {
        StockItem editedObj = this.getCurrentStockItem();
        ObjectTemplate stockItemTemplate = Templates.STOCK_ITEM;
        ObjectChangeRecorder changeRecorder = new ObjectChangeRecorder(stockItemTemplate);
        changeRecorder.snapshot(editedObj);
        GuiApp.getAppComplex().getApplicationFrame().setStatusBarText("Editing " + stockItemTemplate.getName() + ":  " + stockItemTemplate.getObjectText(editedObj));
        ObjectEditorPanel editorView = stockItemTemplate.getNewEditPanel(editedObj);
        if (ObjectEditorDialog.doDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), editorView) == 0) {
            editorView.saveObject();
            StockControlEventLog.logEditStockItem((User)this.getUser(), (StockItem)editedObj, changeRecorder.getChanges(editedObj));
            editedObj.reload();
            this.refresh();
        } else {
            editorView.cancelObject();
        }
        GuiApp.getAppComplex().getApplicationFrame().resetStatusBarText();
    }

    @Override
    public void doPrintAction() {
        StockArea area = this.getCurrentStockArea();
        StockGroup group = this.getCurrentStockGroup();
        String groupString = group != null ? " Group: " + group.toString() : "";
        String areaString = area != null ? " Area: " + area.toString() : "";
        String title = "Stock on hand (" + new DateDMY(System.currentTimeMillis()) + ")";
        Printing.printJTableReport(this.getTableForPrinting(), title, groupString + areaString, 8, this.totalsTable.getColumnStrings());
    }

    private JTable getTableForPrinting() {
        JTable table = this.getActiveTable();
        TableModel tableModel = table.getModel();
        int rowCount = tableModel.getRowCount();
        int colCount = tableModel.getColumnCount();
        Object[] columnNames = new Object[colCount];
        NumberFormat twoDecimalNumberFormat = NumberFormat.getInstance();
        twoDecimalNumberFormat.setMinimumFractionDigits(2);
        twoDecimalNumberFormat.setMaximumFractionDigits(2);
        for (int i = 0; i < colCount; ++i) {
            columnNames[i] = tableModel.getColumnName(i);
        }
        DefaultTableModel printTableModel = new DefaultTableModel(columnNames, 0);
        for (int i = 0; i < rowCount; ++i) {
            Object[] row = new Object[colCount];
            for (int j = 0; j < colCount; ++j) {
                Object value = tableModel.getValueAt(i, j);
                if (value instanceof Double && value.toString().trim().length() > 0) {
                    value = twoDecimalNumberFormat.format(value);
                }
                row[j] = value;
            }
            printTableModel.addRow(row);
        }
        return new JTable(printTableModel);
    }

    public void gotGroupedTableObjectChosen(Integer selIndex) {
        int index = selIndex;
        int oldIndex = this.groupedTable.getGroupedTableModel().getOriginalRow(index);
        if (oldIndex != -1) {
            this.table.setRowSelectionInterval(oldIndex, oldIndex);
            this.doEditAction();
        }
    }

    public StockItem getCurrentStockItem() {
        long id = -1L;
        int originalTableIndex = -1;
        if (this.groupResults) {
            int groupedIndex = this.groupedTable.getSelectedRow();
            originalTableIndex = this.groupedTable.getGroupedTableModel().getOriginalRow(groupedIndex);
        } else {
            originalTableIndex = this.table.getSelectedRow();
        }
        id = this.tableModel.getID(originalTableIndex);
        return id >= 0L ? (StockItem)PersistenceManager.getByID((long)id, StockItem.class) : null;
    }

    void gotTableObjectSelected() {
        this.updateButtonState();
    }

    void gotTreeObjectSelected(Object obj) {
        if (this.updatesAllowed) {
            StockGroup group = null;
            if (obj instanceof StockGroup) {
                group = (StockGroup)obj;
            }
            this.updateQuery(group, this.getCurrentStockArea());
        }
    }

    public StockOnHandSearcher getSearcher() {
        return this.searcher;
    }

    private class StockOnHandSetupTask
    extends AbstractGuiTask {
        private StockOnHandSetupTask() {
        }

        public String getName() {
            return "Loading SOH Report screen...";
        }

        public void doGuiTask() throws Exception {
            StockOnHandState.this.setupGUI();
            this.emitProgress();
            StockOnHandState.this.setupAreasCombo();
            this.emitProgress();
            StockOnHandState.this.setupGroupCheck();
            this.emitProgress();
            StockOnHandState.this.setupTree();
            this.emitProgress();
            StockOnHandState.this.setupTable();
            this.emitProgress();
            StockOnHandState.this.getNewGroupedTable();
            this.emitProgress();
            StockOnHandState.this.refresh();
            StockOnHandState.this.alreadySetup = true;
            this.emitProgress();
        }

        public int getTotalSubTasks() {
            return 7;
        }
    }
}

