/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.timesheet;

import au.com.ordermate.util.DateTimeUtils;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.Component;
import java.awt.FlowLayout;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import officemate.components.AbstractObjectEditor;
import officemate.screens.reports.timesheet.TimesheetTableState;
import ordermate.database.departments.Department;
import ordermate.database.departments.Payrate;
import ordermate.database.finance.timesheet.FinanceTimesheet;
import ordermate.database.misc.TradingDay;
import ordermate.database.queries.department.DepartmentQueries;
import ordermate.database.queries.misc.TradingDayQueries;
import ordermate.database.users.User;
import ordermate.gui.FieldPanelBuilder;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.swingx.JXDatePicker;

public class FinanceTimesheetEditor
extends AbstractObjectEditor<FinanceTimesheet> {
    private JComboBox userCombo;
    private JComboBox deptCombo;
    private EventList<User> userList;
    private EventList<Department> deptList;
    private JXDatePicker datePickerFrom;
    private JXDatePicker datePickerTo;
    private SpinnerDateModel modelIn;
    private SpinnerDateModel modelOut;
    private TimesheetTableState timesheetTableState;

    public FinanceTimesheetEditor() {
    }

    public FinanceTimesheetEditor(TimesheetTableState timesheetTableState) {
        this.timesheetTableState = timesheetTableState;
    }

    @Override
    protected void init() {
        super.init();
        this.userList = GlazedLists.eventList((Collection)User.getUsers());
        this.deptList = GlazedLists.eventList((Collection)DepartmentQueries.getAllDepartments());
        FieldPanelBuilder builder = new FieldPanelBuilder();
        this.getBindings().setStrategy(AutoBinding.UpdateStrategy.READ_WRITE);
        this.userCombo = this.setupComboBox(FinanceTimesheet.Properties.USER, this.userList);
        this.deptCombo = this.setupComboBox(FinanceTimesheet.Properties.DEPARTMENT, this.deptList);
        this.userCombo.setName("User");
        this.deptCombo.setName("Department");
        builder.addRow("User", (Component)this.userCombo);
        builder.addRow("Department", (Component)this.deptCombo);
        builder.addRow("Recorded Clock In", (Component)this.setupLabel(FinanceTimesheet.Properties.TIME_IN));
        builder.addRow("Recorded Clock Out", (Component)this.setupLabel(FinanceTimesheet.Properties.TIME_OUT));
        this.modelIn = new SpinnerDateModel(new Date(), null, null, 11);
        JSpinner timePickerIn = new JSpinner(this.modelIn);
        timePickerIn.setEditor(new JSpinner.DateEditor(timePickerIn, "HH:mm"));
        timePickerIn.setName("inTime");
        this.datePickerFrom = new JXDatePicker();
        this.datePickerFrom.setName("fromDate");
        DateFormat[] formatsPickerFrom = new DateFormat[]{new SimpleDateFormat("dd/MM/yyyy")};
        this.datePickerFrom.setFormats(formatsPickerFrom);
        JPanel panelTimeIn = new JPanel();
        panelTimeIn.setLayout(new FlowLayout(0));
        panelTimeIn.add((Component)this.datePickerFrom);
        panelTimeIn.add(timePickerIn);
        builder.addRow("Modified Clock In", (Component)panelTimeIn);
        this.modelOut = new SpinnerDateModel(new Date(), null, null, 11);
        JSpinner timePickerOut = new JSpinner(this.modelOut);
        timePickerOut.setEditor(new JSpinner.DateEditor(timePickerOut, "HH:mm"));
        timePickerOut.setName("outTime");
        this.datePickerTo = new JXDatePicker();
        DateFormat[] formatsPickerTo = new DateFormat[]{new SimpleDateFormat("dd/MM/yyyy")};
        this.datePickerTo.setFormats(formatsPickerTo);
        this.datePickerTo.setName("toDate");
        JPanel panelTimeOut = new JPanel();
        panelTimeOut.setLayout(new FlowLayout(0));
        panelTimeOut.add((Component)this.datePickerTo);
        panelTimeOut.add(timePickerOut);
        builder.addRow("Modified Clock Out", (Component)panelTimeOut);
        this.add(builder.getPanel());
        this.datePickerFrom.getEditor().getDocument().addDocumentListener(this.getListener());
        this.datePickerTo.getEditor().getDocument().addDocumentListener(this.getListener());
        this.modelOut.addChangeListener(this.getListener());
        this.modelIn.addChangeListener(this.getListener());
        this.objectEdited.connect((Object)this, "gotObjectEdited");
    }

    public void gotObjectEdited() {
        boolean guiValid = this.isGuiValid();
        this.firePropertyChange("guiValid", !guiValid, guiValid);
    }

    private TradingDay getTradingDayForDate(Date date) {
        return TradingDayQueries.getTradingDayForDateAndTime((Date)date);
    }

    @Override
    public FinanceTimesheet getObject() {
        FinanceTimesheet financeTimesheet = (FinanceTimesheet)super.getObject();
        return financeTimesheet;
    }

    @Override
    public boolean isGuiValid() {
        if (this.userCombo.getSelectedItem() == null) {
            return false;
        }
        if (this.deptCombo.getSelectedItem() == null) {
            return false;
        }
        Date in = this.getFromDate();
        Date out = this.getToDate();
        if (in == null) {
            return out == null;
        }
        if (out == null) {
            return in == null;
        }
        if (this.getTradingDayForDate(in) == null) {
            return false;
        }
        return in.before(out) || in.equals(out);
    }

    @Override
    public void setObject(FinanceTimesheet toEdit) {
        this.refreshLists();
        if (toEdit.getDepartment() == null && !this.deptList.isEmpty()) {
            toEdit.setDepartment((Department)this.deptList.get(0));
        }
        if (toEdit.getID() != null) {
            if (toEdit.getTimeInMod() != null) {
                this.datePickerFrom.setDate(toEdit.getTimeInMod());
                this.modelIn.setValue(toEdit.getTimeInMod());
            } else if (toEdit.getTimeIn() != null) {
                this.datePickerFrom.setDate(toEdit.getTimeIn());
                this.modelIn.setValue(toEdit.getTimeIn());
            } else {
                this.datePickerFrom.setDate(new Date());
                this.modelIn.setValue(new Date());
            }
            if (toEdit.getTimeOutMod() != null) {
                this.datePickerTo.setDate(toEdit.getTimeOutMod());
                this.modelOut.setValue(toEdit.getTimeOutMod());
            } else if (toEdit.getTimeOut() != null) {
                this.datePickerTo.setDate(toEdit.getTimeOut());
                this.modelOut.setValue(toEdit.getTimeOut());
            } else {
                this.datePickerTo.setDate(new Date());
                this.modelOut.setValue(new Date());
            }
        } else {
            this.datePickerFrom.setDate(new Date());
            this.datePickerTo.setDate(new Date());
            this.modelIn.setValue(new Date());
            this.modelOut.setValue(new Date());
        }
        if (toEdit.isPersistent()) {
            this.userCombo.setEnabled(false);
        } else {
            this.userCombo.setEnabled(true);
        }
        super.setObject(toEdit);
    }

    private void refreshLists() {
        this.userList.clear();
        this.deptList.clear();
        this.userList.addAll((Collection)GlazedLists.eventList((Collection)User.getUsers()));
        this.deptList.addAll((Collection)GlazedLists.eventList((Collection)DepartmentQueries.getAllDepartments()));
        if (!this.deptList.isEmpty()) {
            this.deptCombo.setSelectedItem(this.deptList.get(0));
        }
    }

    @Override
    public void saveObject() {
        Payrate payRate;
        Date to;
        FinanceTimesheet toEdit = this.getObject();
        boolean modified = false;
        toEdit.setDepartment((Department)this.deptCombo.getSelectedItem());
        Date from = this.getFromDate();
        if (from != null) {
            toEdit.setTimeInMod(from);
            modified = true;
        }
        if ((to = this.getToDate()) != null) {
            toEdit.setTimeOutMod(to);
            modified = true;
        }
        if (modified) {
            toEdit.setNewTimesheetVars();
        }
        if (toEdit.getUser() != null && toEdit.getDepartment() != null && (payRate = toEdit.getUser().getPayrate(toEdit.getDepartment())) != null) {
            toEdit.setPayRate(payRate.getPayRate());
        }
        toEdit.save();
        this.timesheetTableState.refresh();
    }

    protected Date getFromDate() {
        if (this.datePickerFrom.getDate() != null && this.modelIn.getDate() != null) {
            return DateTimeUtils.combineDateAndTime((Date)this.datePickerFrom.getDate(), (Date)this.modelIn.getDate());
        }
        return null;
    }

    protected Date getToDate() {
        if (this.datePickerTo.getDate() != null && this.modelOut.getDate() != null) {
            return DateTimeUtils.combineDateAndTime((Date)this.datePickerTo.getDate(), (Date)this.modelOut.getDate());
        }
        return null;
    }
}

