/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.timesheet;

import au.com.ordermate.gui.adminkit.AdminGuiUtils;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.search.control.RefreshAction;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import officemate.screens.reports.jasper.JasperReportState;
import officemate.screens.reports.jasper.JasperToolbarFactory;
import officemate.screens.reports.timesheet.TimesheetActionHelper;
import officemate.screens.reports.timesheet.TimesheetSearchState;
import ordermate.database.finance.timesheet.FinanceTimesheet;
import ordermate.database.reports.timesheet.TimesheetsDetailReportProvider;
import ordermate.database.users.AllPermissions;
import ordermate.gui.FieldPanelBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.ReportProvider;
import ordermate.reports.impl.EmptyReportProvider;

public class TimesheetDetailReportState
extends JasperReportState {
    private TimesheetSearchState searchState;
    private TimesheetsDetailReportProvider reportProvider;
    private TimesheetActionHelper actionHelper;
    private JComboBox groupingComboBox;

    public TimesheetDetailReportState(TimesheetSearchState timesheetSearchState, TimesheetActionHelper actionHelper) {
        super(null, "Detailed Report", AllPermissions.ACCESS_USERS_SCREEN, "Show detailed report of Timesheets.");
        this.searchState = timesheetSearchState;
        this.actionHelper = actionHelper;
        this.setReportProvider((ReportProvider)new EmptyReportProvider());
        this.setNoResultText("There are no results for the report criteria or there are no users in the system with a Payroll ID.");
        this.groupingComboBox = new JComboBox<TimesheetsDetailReportProvider.Grouping>(TimesheetsDetailReportProvider.Grouping.values());
        this.groupingComboBox.setName("groupingComboBox");
        this.groupingComboBox.addActionListener((ActionListener)new RefreshAction((Refreshable)this));
        AdminGuiUtils.getInstance().standardComboSetup(this.groupingComboBox);
    }

    @Override
    protected void init() {
        if (this.hasUserPermission() && this.reportProvider == null) {
            this.reportProvider = new TimesheetsDetailReportProvider(this.getSearchState().getSearcher());
            this.setReportProvider((ReportProvider)this.reportProvider);
        }
        super.init();
        if (this.isFirstRun()) {
            this.actionHelper.addStateSpecificActions(this);
        }
    }

    @Override
    public void refresh() {
        this.reportProvider.setGrouping((TimesheetsDetailReportProvider.Grouping)this.groupingComboBox.getSelectedItem());
        super.refresh();
    }

    @Override
    protected JasperToolbarFactory createJasperToolbarFactory() {
        return new JasperToolbarFactory(){

            @Override
            protected JComponent getCustomReportControlPanel() {
                FieldPanelBuilder builder = new FieldPanelBuilder();
                builder.addRow("Group By:", (Component)TimesheetDetailReportState.this.groupingComboBox);
                return builder.getPanel();
            }
        };
    }

    private TimesheetSearchState getSearchState() {
        if (this.searchState == null) {
            this.searchState = new TimesheetSearchState((EventList<FinanceTimesheet>)new BasicEventList());
        }
        return this.searchState;
    }

    private boolean hasUserPermission() {
        return this.getUser() != null ? this.getUser().hasPermission(AllPermissions.PRINT_TIMESHEET) : false;
    }
}

