/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.timesheet;

import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.DateTimeUtils;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.List;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.PropertyAccessorColumnFormat;
import officemate.screens.reports.timesheet.FinanceTimesheetEditor;
import officemate.screens.reports.timesheet.TimesheetActionHelper;
import officemate.screens.reports.timesheet.TimesheetSearchState;
import ordermate.database.departments.Department;
import ordermate.database.finance.timesheet.FinanceTimesheet;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.User;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class TimesheetTableState
extends AbstractEditableTableState<FinanceTimesheet> {
    private TimesheetSearchState searchState;
    private TimesheetActionHelper actionHelper;
    private List<User> activeUserList;

    public TimesheetTableState(TimesheetSearchState timesheetSearchState) {
        super("Timesheet", AllPermissions.EDIT_TIMESHEET, "Search and edit Timesheets.");
        this.searchState = timesheetSearchState;
        this.actionHelper = new TimesheetActionHelper(this, this.getColumnFormat());
    }

    @Override
    protected ObjectEditor<FinanceTimesheet> createObjectEditor() {
        if (!this.hasUserPermission()) {
            return null;
        }
        return new FinanceTimesheetEditor(this);
    }

    @Override
    public String getTypeName() {
        return "Timesheet";
    }

    @Override
    protected TableStateCentralArea<FinanceTimesheet> createCentralArea() {
        ColumnFormat[] columns = this.getColumnFormat();
        ColumnTableFormat format = new ColumnTableFormat(columns);
        PersistentObjectTable<FinanceTimesheet> table = new PersistentObjectTable<FinanceTimesheet>(this.getObjectList(), format);
        this.actionHelper.addStateSpecificActions(this);
        return table;
    }

    TimesheetActionHelper getActionHelper() {
        return this.actionHelper;
    }

    private ColumnFormat[] getColumnFormat() {
        return new ColumnFormat[]{new PropertyAccessorColumnFormat("Payroll ID", new PropertiedObject.Property[]{FinanceTimesheet.Properties.USER, User.Properties.PAYROLL_ID}, null), new PropertyAccessorColumnFormat("User Name", new PropertiedObject.Property[]{FinanceTimesheet.Properties.USER, User.Properties.NAME}, null), new PropertyAccessorColumnFormat("Department", new PropertiedObject.Property[]{FinanceTimesheet.Properties.DEPARTMENT, Department.Properties.NAME}, null), new PropertyColumnFormat((PropertiedObject.Property)FinanceTimesheet.Properties.REPORTING_TIME_IN).setName("Time In").setFormatter((Format)DateTimeUtils.getConsistent24HourReportDateFormat()), new PropertyColumnFormat((PropertiedObject.Property)FinanceTimesheet.Properties.REPORTING_TIME_OUT).setName("Time Out").setFormatter((Format)DateTimeUtils.getConsistent24HourReportDateFormat()), new PropertyColumnFormat((PropertiedObject.Property)FinanceTimesheet.Properties.MODIFIED).setName("Time Punch Altered"), new PropertyColumnFormat((PropertiedObject.Property)FinanceTimesheet.Properties.TOTAL_MILLIS).setName("Time Worked").setFormatter(new Format(){

            @Override
            public Object parseObject(String source, ParsePosition pos) {
                return null;
            }

            @Override
            public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
                Long millis = (Long)obj;
                toAppendTo.append(DateTimeUtils.toHoursMinutes((long)millis));
                return toAppendTo;
            }
        }), new PropertyColumnFormat(FinanceTimesheet.Properties.TOTAL_PAY).setName("Total Pay")};
    }

    @Override
    protected OfficeMateObjectSearch<FinanceTimesheet> createSearchPanelFactory() {
        return this.searchState;
    }

    @Override
    protected Class<FinanceTimesheet> getDisplayingType() {
        return FinanceTimesheet.class;
    }

    @Override
    protected FinanceTimesheet createNewObject() {
        if (this.hasUserPermission()) {
            return (FinanceTimesheet)super.createNewObject();
        }
        return null;
    }

    private boolean hasUserPermission() {
        return this.getUser().hasPermission(AllPermissions.PRINT_TIMESHEET);
    }
}

