/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.tips;

import au.com.ordermate.persistence.PropertiedObject;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.table.AbstractTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.screens.reports.CSVExportAction;
import officemate.screens.reports.tips.TipsReportSearchControl;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.reports.tips.TipsReport;
import ordermate.database.reports.tips.TipsReportSearcher;
import ordermate.database.users.AllPermissions;
import ordermate.gui.binding.ColumnVisibilityHelper;

public class TipsReportState
extends AbstractTableState<TipsReport> {
    private final EventList<TipsReport> tableData = new BasicEventList();
    private TipsReportSearcher searcher = new TipsReportSearcher();
    private TipsReportSearchControl searchControl;
    private PersistentObjectTable centralArea;
    private List<String> units = new ArrayList<String>();

    public TipsReportState() {
        super("Tips Report", AllPermissions.ACCESS_SALES_REPORT, "View tips report.");
        for (FinanceUnit unit : FinanceUnit.getActiveTipsFinanceUnits()) {
            this.units.add(unit.getLabel());
        }
    }

    @Override
    protected void init() {
        if (this.initCalled) {
            return;
        }
        super.init();
    }

    @Override
    public TableStateCentralArea<TipsReport> createCentralArea() {
        ArrayList<PropertiedObject.Property> hiddenList = new ArrayList<PropertiedObject.Property>();
        hiddenList.add(TipsReport.Properties.SHIFT);
        PropertiedObject.Property[] hiddenProps = hiddenList.toArray(new PropertiedObject.Property[0]);
        this.centralArea = new PersistentObjectTable(this.getObjectList(), new ColumnTableFormat(this.searcher.getTipsReportProvider().getColumnFormat()), hiddenProps);
        for (FinanceUnit unit : FinanceUnit.getActiveTipsFinanceUnits()) {
            this.centralArea.getTable().getColumnExt((Object)unit.getLabel()).setVisible(false);
        }
        this.buildCheckBoxes();
        this.centralArea.add((Component)this.searchControl.getSearchPanel(), "North");
        this.addAction(new CSVExportAction(this.getObjectList(), this.searcher.getTipsReportProvider().getColumnFormat(), "TipsReport.csv"));
        return this.centralArea;
    }

    private void buildCheckBoxes() {
        ColumnVisibilityHelper showShift = new ColumnVisibilityHelper((Object[])new PropertiedObject.Property[]{TipsReport.Properties.SHIFT}, this.searchControl.getShiftBox(), this.centralArea.getTable());
        ColumnVisibilityHelper showFinanceUnit = new ColumnVisibilityHelper(this.units.toArray(), this.searchControl.getFinanceUnitBox(), this.centralArea.getTable());
    }

    @Override
    public Class<TipsReport> getDisplayingType() {
        return TipsReport.class;
    }

    @Override
    public OfficeMateObjectSearch<TipsReport> createSearchPanelFactory() {
        this.getSearcher();
        this.searchControl = new TipsReportSearchControl(this.searcher, this.tableData);
        return this.searchControl;
    }

    public TipsReportSearcher getSearcher() {
        if (this.searcher == null) {
            this.searcher = new TipsReportSearcher();
        }
        return this.searcher;
    }

    @Override
    public void refresh() {
        this.getSearcher().setShowFinanceUnits(this.searchControl.getFinanceUnitBox().isSelected());
        this.getSearcher().setShowFinanceUnits(this.searchControl.getShiftBox().isSelected());
        super.refresh();
    }
}

