/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.transaction;

import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.searchfield.java.ComboSearchField;
import au.com.ordermate.search.searchfield.java.DateRangeSearchField;
import au.com.ordermate.search.searchfield.java.MultiSelectComboSearchField;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import au.com.ordermate.search.searchfield.java.StringSearchField;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.util.Collection;
import java.util.Date;
import javax.swing.Action;
import officemate.components.search.ObjectPropertySearch;
import officemate.components.search.searchfield.IntegerRangeSearchField;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.hardware.physical.VirtualEftpos;
import ordermate.database.sales.AccountType;
import ordermate.database.searchers.finance.FinanceTransactionSearcher;
import ordermate.database.users.User;

public class FinanceTransactionSearch
extends ObjectPropertySearch<FinanceTransaction> {
    public FinanceTransactionSearch(FinanceTransactionSearcher searcher) {
        super(FinanceTransaction.class, searcher, new BasicEventList());
        this.setupFields();
    }

    private void setupFields() {
        RefreshAction refresh = new RefreshAction((Refreshable)this);
        FinanceTransactionSearcher mySearcher = (FinanceTransactionSearcher)this.getPropertySearcher();
        this.addSearchField((SearchGuiField)new DateRangeSearchField("Date", (IRangedQuerySearchFilter)mySearcher.getTradingDayFilter(), new Date(), (Action)refresh));
        this.addSearchField((SearchGuiField)new StringSearchField("Reference", (ISingleValueSearchFilter)mySearcher.getReferenceFilter(), (Action)refresh));
        this.addSearchField((SearchGuiField)new StringSearchField("Source", (ISingleValueSearchFilter)mySearcher.getSourceFilter(), (Action)refresh));
        this.addSearchField((SearchGuiField)new MultiSelectComboSearchField("CashDrawer", mySearcher.getCashdrawerFilter(), (Action)refresh, GlazedLists.eventList((Collection)CashDrawer.getAllCashDrawers())));
        this.addSearchField((SearchGuiField)new MultiSelectComboSearchField("Terminal", mySearcher.getTerminalFilter(), (Action)refresh, GlazedLists.eventList((Collection)Terminal.getAllTerminals())));
        this.addSearchField((SearchGuiField)new MultiSelectComboSearchField("User", mySearcher.getUserFilter(), (Action)refresh, GlazedLists.eventList((Collection)User.getUsers())));
        this.addSearchField((SearchGuiField)new MultiSelectComboSearchField("Sales Location", mySearcher.getSalesLocationFilter(), (Action)refresh, GlazedLists.eventList((Collection)SalesLocation.getSalesLocations())));
        this.addSearchField((SearchGuiField)new MultiSelectComboSearchField("Eftpos Terminal", mySearcher.getEftposFilter(), (Action)refresh, GlazedLists.eventList((Collection)PersistenceManager.getObjectList(VirtualEftpos.class, (String)Query.select(VirtualEftpos.class).active(VirtualEftpos.class).toString()))));
        this.addSearchField((SearchGuiField)new MultiSelectComboSearchField("Type", mySearcher.getTypeFilter(), (Action)refresh, GlazedLists.eventListOf((Object[])new FinanceUnit.FinanceUnitType[]{FinanceUnit.CASH_TYPE, FinanceUnit.CREDIT_TYPE, FinanceUnit.DEBIT_TYPE, FinanceUnit.WEB_TYPE, FinanceUnit.MOTO_TYPE})));
        this.addSearchField((SearchGuiField)new MultiSelectComboSearchField("Unit", mySearcher.getUnitFilter(), (Action)refresh, GlazedLists.eventList((Collection)FinanceUnit.getAllUnits())));
        this.addSearchField((SearchGuiField)new MultiSelectComboSearchField("Account Type", mySearcher.getAccountTypeFilter(), (Action)refresh, GlazedLists.eventListOf((Object[])AccountType.getTypes())));
        this.addSearchField(new IntegerRangeSearchField("Paid", (IRangedQuerySearchFilter<Integer>)mySearcher.getPaidRangeFilter(), (Action)refresh));
        BasicEventList stateList = new BasicEventList();
        stateList.add((Object)"ACTIVE");
        stateList.add((Object)"DELETED");
        stateList.add((Object)"MOVED");
        ComboSearchField stateField = new ComboSearchField("State", (ISingleValueSearchFilter)mySearcher.getSystemStateFilter(), true, (Action)refresh, (EventList)stateList);
        this.addSearchField((SearchGuiField)stateField);
        stateField.setSelectedObject((Object)"ACTIVE");
    }
}

