/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.usage;

import au.com.ordermate.application.ApplicationContext;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.sql.queries.SelectQuery;
import au.com.ordermate.util.MathsUtils;
import au.com.ordermate.util.Price;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import officemate.adminkit.table.QueryTableModel;
import ordermate.database.config.MeasureUnitContainer;
import ordermate.database.config.Quantity;
import ordermate.database.stock.StockItem;
import stockmate.database.interfaces.stock.MeasureUnitI;

public class StockUsageTableModel
extends QueryTableModel {
    private ApplicationContext context;
    private List deletedList = new ArrayList();

    public StockUsageTableModel(SelectQuery selQuery, String idField, String[] colNames, String[] colDisplayNames, ApplicationContext dbContext) {
        super(selQuery, dbContext.getDatabaseConnection(), idField, colNames, colDisplayNames);
        this.context = dbContext;
    }

    @Override
    public void update() {
        this.deletedList.clear();
        super.update();
    }

    @Override
    protected Object getTableValue(int row, int col, String colName, int dbColIndex, ResultSet rs) throws SQLException {
        try {
            if (colName.equals("ItemUsage") || colName.equals("ItemWastage") || colName.equals("ItemSold") || colName.equals("ItemPreProd") || colName.equals("ItemAdjust") || colName.equals("YieldLoss")) {
                long StockItemId;
                StockItem item;
                MeasureUnitContainer measureUnitContainer;
                double priceVal = rs.getDouble(colName);
                if (priceVal < (measureUnitContainer = (item = (StockItem)PersistenceManager.getByID((long)(StockItemId = rs.getLong("stock_item.ID")), StockItem.class)).getDisplayMeasureUnitContainer()).getQuantityPerContainer()) {
                    return new Quantity((MeasureUnitI)measureUnitContainer.getMeasureUnit(), priceVal, true);
                }
                return new Quantity(measureUnitContainer, priceVal, true);
            }
            if (colName.equals("UsageCost")) {
                return new Price(rs.getDouble(colName), 0.0);
            }
            if (colName.equals("WastePercent") || colName.equals("YieldLossPercent")) {
                double priceVal = rs.getDouble(colName);
                return new Double(MathsUtils.roundDoubleToDecPlaces((double)priceVal, (int)2));
            }
            if (col == 0) {
                String systemState = rs.getString("stock_item.system_state");
                boolean deleted = !systemState.equals("ACTIVE");
                this.deletedList.add(deleted ? Boolean.TRUE : Boolean.FALSE);
            }
        }
        catch (SQLException e) {
            this.context.getLog().error("Cannot access table.", (Throwable)e);
            return null;
        }
        return super.getTableValue(row, col, colName, dbColIndex, rs);
    }

    @Override
    protected Number getTotalValue(int column, double rawValue, String colName, int dbColIndex) {
        if (colName.equals("UsageCost")) {
            return new Price(rawValue, 0.01);
        }
        return super.getTotalValue(column, rawValue, colName, dbColIndex);
    }

    public boolean isRowDeleted(int row) {
        boolean deleted = false;
        if (this.deletedList.size() > row) {
            Boolean b = (Boolean)this.deletedList.get(row);
            deleted = b;
        }
        return deleted;
    }
}

