/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.vouchers.audit;

import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.search.control.DateRangePanel;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.searchfield.java.ComboSearchField;
import au.com.ordermate.search.searchfield.java.DateRangeSearchField;
import au.com.ordermate.search.searchfield.java.MultiSelectComboSearchField;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import officemate.components.search.ObjectPropertySearch;
import officemate.components.search.SearchBarPanel;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.finance.giftvoucher.GiftVoucher;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.integration.giftvoucher.GiftVoucherConfiguration;
import ordermate.database.queries.finance.voucher.VoucherQueries;
import ordermate.database.searchers.reports.vouchers.VoucherTransactionSearcher;

public class VoucherAuditSearch
extends ObjectPropertySearch<GiftVoucherTransaction>
implements ItemListener,
ActionListener {
    private final VoucherTransactionSearcher searcher;
    private EventList<GiftVoucherConfiguration> providers;
    private EventList<GiftVoucher> vouchers;
    private final DateRangeSearchField dateRangeField;
    private final ComboSearchField providerComboField;
    private final ComboSearchField voucherComboField;
    private final MultiSelectComboSearchField salesLocationField;

    public VoucherAuditSearch() {
        super(GiftVoucherTransaction.class);
        RefreshAction refresh = new RefreshAction((Refreshable)this);
        this.searcher = (VoucherTransactionSearcher)this.getPropertySearcher();
        this.dateRangeField = new DateRangeSearchField("Date Used", this.searcher.getCreatedDayRangeFilter(), null, (Action)refresh);
        this.dateRangeField.getDateRangePanel().getStartPicker().addActionListener((ActionListener)this);
        this.dateRangeField.getDateRangePanel().getEndPicker().addActionListener((ActionListener)this);
        this.addSearchField((SearchGuiField)this.dateRangeField);
        this.providerComboField = new ComboSearchField("Provider", (ISingleValueSearchFilter)null, false, (Action)refresh, this.getProviders());
        this.providerComboField.getComboBox().addItemListener(this);
        this.providerComboField.getComboBox().setPreferredSize(new Dimension(this.providerComboField.getComboBox().getPreferredSize().width + 50, this.providerComboField.getComboBox().getPreferredSize().height));
        this.addSearchField((SearchGuiField)this.providerComboField);
        this.voucherComboField = new ComboSearchField("Voucher", this.searcher.getVoucherFilter(), false, (Action)refresh, this.getVouchers());
        this.voucherComboField.setRenderer(this.createVoucherRenderer());
        this.voucherComboField.getComboBox().addItemListener(this);
        this.voucherComboField.getComboBox().setPreferredSize(new Dimension(this.voucherComboField.getComboBox().getPreferredSize().width + 50, this.voucherComboField.getComboBox().getPreferredSize().height));
        this.voucherComboField.setEnabled(false);
        this.addSearchField((SearchGuiField)this.voucherComboField);
        this.salesLocationField = new MultiSelectComboSearchField("Sales Location", this.searcher.getSalesLocationFilter(), (Action)refresh, GlazedLists.eventList((Collection)SalesLocation.getSalesLocations()));
        this.addSearchField((SearchGuiField)this.salesLocationField);
        this.refreshVoucherList();
    }

    public void selectVoucher(GiftVoucher voucher) {
        this.dateRangeField.getDateRangePanel().setDates(voucher.getCreationDate(), new Date());
        this.providerComboField.setSelectedObject((Object)VoucherQueries.getConfigForVoucher((GiftVoucher)voucher));
        this.voucherComboField.setSelectedObject((Object)voucher);
        this.voucherComboField.setEnabled(true);
        this.searcher.clearSearchFilterValues();
        this.searcher.getVoucherFilter().setSearchValue((Object)voucher);
        this.doRefresh();
    }

    @Override
    protected ObjectQuerySearcher<GiftVoucherTransaction> constructPropertySearcher() {
        return new VoucherTransactionSearcher();
    }

    @Override
    protected void addToSearchGui(SearchBarPanel searchGui, SearchGuiField field) {
        if (field instanceof DateRangeSearchField) {
            DateRangePanel panel = ((DateRangeSearchField)field).getDateRangePanel();
            searchGui.addSearchField("Start Date Used:", (Component)panel.getStartPicker());
            searchGui.addSearchField("End Date Used:", (Component)panel.getEndPicker());
        } else {
            super.addToSearchGui(searchGui, field);
        }
    }

    private EventList<GiftVoucherConfiguration> getProviders() {
        this.providers = GlazedLists.eventList((Collection)VoucherQueries.getActiveVoucherProviders());
        return this.providers;
    }

    private EventList<GiftVoucher> getVouchers() {
        GiftVoucherConfiguration config = (GiftVoucherConfiguration)this.providerComboField.getSelectedObject();
        this.vouchers = config != null ? GlazedLists.eventList((Collection)VoucherQueries.getVouchersForConfigUsedBetweenDates((GiftVoucherConfiguration)config, (Date)this.dateRangeField.getDateRangePanel().getStartDate(), (Date)this.dateRangeField.getDateRangePanel().getEndDate())) : GlazedLists.eventList(new ArrayList());
        return this.vouchers;
    }

    private ListCellRenderer createVoucherRenderer() {
        return new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                GiftVoucher gv = (GiftVoucher)value;
                ((JLabel)comp).setText(gv.getUniqueId() + " " + gv.getCachedValue().toString());
                return comp;
            }
        };
    }

    @Override
    public void doRefresh() {
        super.doRefresh();
        if (this.voucherComboField != null && this.voucherComboField.getSelectedObject() == null) {
            this.clearObjectList();
        }
    }

    private void handleFilterChange(AWTEvent e) {
        if (e.getSource() == this.providerComboField.getComboBox() && ((ItemEvent)e).getStateChange() == 1) {
            this.refreshVoucherList();
        } else if (e.getSource() == this.dateRangeField.getDateRangePanel().getStartPicker() || e.getSource() == this.dateRangeField.getDateRangePanel().getEndPicker()) {
            this.refreshVoucherList();
        } else if (e.getSource() == this.voucherComboField.getComboBox()) {
            // empty if block
        }
    }

    private void refreshVoucherList() {
        if (this.voucherComboField != null) {
            this.voucherComboField.setEnabled(false);
            this.voucherComboField.setListData(this.getVouchers());
            if (!this.vouchers.isEmpty()) {
                this.voucherComboField.setEnabled(true);
            } else {
                this.clearObjectList();
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.handleFilterChange(e);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.handleFilterChange(e);
    }

    public VoucherTransactionSearcher getSearcher() {
        return (VoucherTransactionSearcher)this.getPropertySearcher();
    }
}

