/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.vouchers.audit;

import officemate.components.OfficeMateObjectSearch;
import officemate.components.table.AbstractTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.screens.reports.vouchers.audit.VoucherAuditSearch;
import officemate.screens.reports.vouchers.audit.VoucherAuditTableColumnFormat;
import ordermate.database.finance.giftvoucher.GiftVoucher;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.searchers.reports.vouchers.VoucherTransactionSearcher;
import ordermate.database.users.AllPermissions;

public class VoucherAuditState
extends AbstractTableState<GiftVoucherTransaction> {
    public VoucherAuditState() {
        super("Voucher Audit", AllPermissions.VOUCHER_REPORTS, "View individual redeem, top up, and reversal transactions for a voucher.");
    }

    @Override
    protected TableStateCentralArea<GiftVoucherTransaction> createCentralArea() {
        return new PersistentObjectTable<GiftVoucherTransaction>(this.getObjectList(), new VoucherAuditTableColumnFormat());
    }

    @Override
    protected Class<GiftVoucherTransaction> getDisplayingType() {
        return GiftVoucherTransaction.class;
    }

    @Override
    protected OfficeMateObjectSearch<GiftVoucherTransaction> createSearchPanelFactory() {
        return new VoucherAuditSearch();
    }

    public void setVoucher(GiftVoucher voucher) {
        VoucherAuditSearch search = (VoucherAuditSearch)this.getSearchFactory();
        search.selectVoucher(voucher);
    }

    public VoucherTransactionSearcher getSearcher() {
        this.init();
        return ((VoucherAuditSearch)this.getSearchFactory()).getSearcher();
    }
}

