/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.weekdaysales;

import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.Format;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.JTextComponent;
import officemate.adminkit.state.SearchGuiState;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.table.AbstractTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.PropertyAccessorColumnFormat;
import officemate.screens.reports.weekdaysales.WeekdaySalesByHourReportSearchControl;
import ordermate.database.searchers.reports.weekdaysales.DayOfWeekSummary;
import ordermate.database.searchers.reports.weekdaysales.WeekdaySalesByHourReportCompiler;
import ordermate.database.searchers.reports.weekdaysales.WeekdaySalesByHourReportSummary;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class WeekdaySalesByHourReportSearchState
extends AbstractTableState<WeekdaySalesByHourReportSummary>
implements SearchGuiState,
ActionListener {
    private WeekdaySalesByHourReportCompiler compiler;
    private JCheckBox hidePeriodsWithNoData;
    private WeekdaySalesByHourReportSearchControl searchControl;

    public WeekdaySalesByHourReportSearchState(WeekdaySalesByHourReportCompiler compiler) {
        super("Search", null, "Select date to report on.");
        this.compiler = compiler;
    }

    @Override
    protected TableStateCentralArea<WeekdaySalesByHourReportSummary> createCentralArea() {
        DecimalFormat twoDigitDecimalFormat = new DecimalFormat("0.00");
        DecimalFormatRenderer decimalFormatRenderer = new DecimalFormatRenderer();
        ColumnTableFormat colFormat = new ColumnTableFormat(new ColumnFormat[]{new PropertyColumnFormat(WeekdaySalesByHourReportSummary.Properties.HOUR_OF_DAY).setName("Hour Of Day").setCustomRenderer((TableCellRenderer)new TimePeriodRenderer()), new PropertyAccessorColumnFormat(WeekdaySalesByHourReportSummary.Properties.MONDAY_SUMMARY, DayOfWeekSummary.Properties.AVERAGE_SALES, (Format)twoDigitDecimalFormat).setCustomRenderer(decimalFormatRenderer).setName("Monday"), new PropertyAccessorColumnFormat(WeekdaySalesByHourReportSummary.Properties.TUESDAY_SUMMARY, DayOfWeekSummary.Properties.AVERAGE_SALES, (Format)twoDigitDecimalFormat).setCustomRenderer(decimalFormatRenderer).setName("Tuesday"), new PropertyAccessorColumnFormat(WeekdaySalesByHourReportSummary.Properties.WEDNESDAY_SUMMARY, DayOfWeekSummary.Properties.AVERAGE_SALES, (Format)twoDigitDecimalFormat).setCustomRenderer(decimalFormatRenderer).setName("Wednesday"), new PropertyAccessorColumnFormat(WeekdaySalesByHourReportSummary.Properties.THURSDAY_SUMMARY, DayOfWeekSummary.Properties.AVERAGE_SALES, (Format)twoDigitDecimalFormat).setCustomRenderer(decimalFormatRenderer).setName("Thursday"), new PropertyAccessorColumnFormat(WeekdaySalesByHourReportSummary.Properties.FRIDAY_SUMMARY, DayOfWeekSummary.Properties.AVERAGE_SALES, (Format)twoDigitDecimalFormat).setCustomRenderer(decimalFormatRenderer).setName("Friday"), new PropertyAccessorColumnFormat(WeekdaySalesByHourReportSummary.Properties.SATURDAY_SUMMARY, DayOfWeekSummary.Properties.AVERAGE_SALES, (Format)twoDigitDecimalFormat).setCustomRenderer(decimalFormatRenderer).setName("Saturday"), new PropertyAccessorColumnFormat(WeekdaySalesByHourReportSummary.Properties.SUNDAY_SUMMARY, DayOfWeekSummary.Properties.AVERAGE_SALES, (Format)twoDigitDecimalFormat).setCustomRenderer(decimalFormatRenderer).setName("Sunday")});
        return new PersistentObjectTable<WeekdaySalesByHourReportSummary>(this.getObjectList(), colFormat);
    }

    @Override
    protected Class<WeekdaySalesByHourReportSummary> getDisplayingType() {
        return WeekdaySalesByHourReportSummary.class;
    }

    @Override
    protected OfficeMateObjectSearch<WeekdaySalesByHourReportSummary> createSearchPanelFactory() {
        this.searchControl = new WeekdaySalesByHourReportSearchControl(this.compiler);
        JPanel panel = this.searchControl.getSearchPanel();
        JPanel additionalOptionsPanel = new JPanel();
        this.hidePeriodsWithNoData = new JCheckBox();
        this.hidePeriodsWithNoData.addActionListener(this);
        additionalOptionsPanel.add(new JLabel("Hide Periods With No Sales"));
        additionalOptionsPanel.add(this.hidePeriodsWithNoData);
        panel.add((Component)additionalOptionsPanel, "East");
        return this.searchControl;
    }

    public ObjectQuerySearcher getSearcher() {
        return this.compiler.getSearcher();
    }

    private void hidePeriodsWithNoData() {
        this.compiler.setFilterPeriodsWithNoSalesData(this.hidePeriodsWithNoData.isSelected());
        this.searchControl.doRefresh();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.hidePeriodsWithNoData) {
            this.hidePeriodsWithNoData();
        }
    }

    static class DecimalFormatRenderer
    extends DefaultTableCellRenderer {
        DecimalFormat df = new DecimalFormat("0.00");

        DecimalFormatRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            String displayText = this.df.format(value);
            if (comp instanceof JTextComponent) {
                ((JTextComponent)comp).setText(displayText);
            } else if (comp instanceof JLabel) {
                ((JLabel)comp).setText(displayText);
                ((JLabel)comp).setHorizontalAlignment(4);
            }
            return comp;
        }
    }

    static class TimePeriodRenderer
    extends DefaultTableCellRenderer {
        TimePeriodRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Integer startHour = (Integer)value;
            Integer endHour = startHour + 1;
            String displayTxt = String.format("%02d", startHour) + ":00 - " + String.format("%02d", endHour) + ":00";
            if (comp instanceof JTextComponent) {
                ((JTextComponent)comp).setText(displayTxt);
            } else if (comp instanceof JLabel) {
                ((JLabel)comp).setText(displayTxt);
            }
            return comp;
        }
    }
}

