/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.accounting;

import au.com.ordermate.persistence.PropertiedObject;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.TextFilterator;
import ca.odell.glazedlists.matchers.TextMatcherEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.components.table.PersistentObjectTable;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.EditablePropertyColumnFormat;
import officemate.components.tableformat.renderers.AutoCompleteComboCellEditor;
import officemate.screens.setup.configuration.accounting.SimpleSelectionTreePanel;
import ordermate.OrderMate;
import ordermate.database.integration.accounting.AccountingIntegrationConfig;
import ordermate.database.integration.accounting.settings.GLAccount;
import ordermate.integration.finance.AccountingExportType;
import ordermate.reports.accounting.GLCodeLinkReport;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import org.jdesktop.swingx.JXHeader;

public class GLAccountLinkPanel
extends JPanel {
    public final Signal tableEdited = Signals.createSignal(Object.class, (String)"edited object");
    private JSplitPane splitter;
    private PersistentObjectTable<GLCodeLinkReport> table;
    private SimpleSelectionTreePanel typeTreePanel;
    private EventList<GLAccount> allGLCodes = new BasicEventList();
    private FilterList<GLCodeLinkReport> filteredGLCodes;
    private TextMatcherEditor<GLCodeLinkReport> textMatcher;
    private GLAccount emptyGlAccount;

    public GLAccountLinkPanel(EventList<GLCodeLinkReport> glCodeLinkReport) {
        this.setLayout(new BorderLayout());
        this.setName("GL Code Links");
        JXHeader instructionsHeading = new JXHeader("", "Use this screen to setup the links to the GL Accounts. GL Accounts in italic are using the default GL Account.");
        Box box = new Box(1);
        box.add((Component)instructionsHeading);
        box.add(new JSeparator());
        this.add((Component)box, "North");
        this.splitter = new JSplitPane();
        this.typeTreePanel = new SimpleSelectionTreePanel(this.buildTreeNodeStructure());
        this.typeTreePanel.objectSelected.connect((Object)this, "setExportTypeFilter");
        this.splitter.setLeftComponent(this.typeTreePanel);
        this.textMatcher = new TextMatcherEditor((TextFilterator)new ExportTypeFilterator());
        this.filteredGLCodes = new FilterList(glCodeLinkReport, this.textMatcher);
        this.initTable();
        this.add((Component)this.splitter, "Center");
    }

    private DefaultMutableTreeNode buildTreeNodeStructure() {
        DefaultMutableTreeNode allNode = new DefaultMutableTreeNode("All");
        for (AccountingExportType exportType : AccountingExportType.values()) {
            allNode.add(new DefaultMutableTreeNode(exportType.getDescription()));
        }
        return allNode;
    }

    public void initTable() {
        ColumnFormat[] colsFormat = AccountingIntegrationConfig.getInstance().isGroupBySalesLocation() ? new ColumnFormat[]{new PropertyColumnFormat("Type", GLCodeLinkReport.Properties.EXPORT_TYPE).setCustomRenderer((TableCellRenderer)new ExportTypeCellRenderer()), new PropertyColumnFormat("Sales Location", GLCodeLinkReport.Properties.SALES_LOCATION), new PropertyColumnFormat("Name", (PropertiedObject.Property)GLCodeLinkReport.Properties.DISPLAYABLE_DESCRIPTION), ((EditablePropertyColumnFormat)new EditablePropertyColumnFormat("GL Account", GLCodeLinkReport.Properties.GL_ACCOUNT).setCustomRenderer(new GLAccountCellRenderer())).setCustomEditor((TableCellEditor)((Object)new GLLinkCompleteComboCellEditor(this.allGLCodes, false).setComboRenderer(new GLAccountListRenderer())))} : new ColumnFormat[]{new PropertyColumnFormat("Type", GLCodeLinkReport.Properties.EXPORT_TYPE).setCustomRenderer((TableCellRenderer)new ExportTypeCellRenderer()), new PropertyColumnFormat("Name", (PropertiedObject.Property)GLCodeLinkReport.Properties.DISPLAYABLE_DESCRIPTION), ((EditablePropertyColumnFormat)new EditablePropertyColumnFormat("GL Account", GLCodeLinkReport.Properties.GL_ACCOUNT).setCustomRenderer(new GLAccountCellRenderer())).setCustomEditor((TableCellEditor)((Object)new GLLinkCompleteComboCellEditor(this.allGLCodes, false).setComboRenderer(new GLAccountListRenderer())))};
        this.table = new PersistentObjectTable<GLCodeLinkReport>((EventList<GLCodeLinkReport>)this.filteredGLCodes, new ColumnTableFormat(colsFormat));
        this.splitter.setRightComponent(this.table);
        this.splitter.setDividerLocation(160);
        this.table.objectEdited().connect((Object)this, "glCodeEdited");
    }

    private void getGLCodeComboBoxEditor() {
        ArrayList<GLAccount> allAccounts = new ArrayList<GLAccount>();
        allAccounts.add(this.getEmptyGlAccount());
        allAccounts.addAll(GLAccount.getGLAccounts());
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.allGLCodes, allAccounts);
    }

    public void refresh() {
        this.getGLCodeComboBoxEditor();
    }

    protected void setExportTypeFilter(Object selected) {
        if (this.table.getTable().isEditing()) {
            this.table.getTable().getCellEditor().stopCellEditing();
        }
        try {
            if (!"All".equals(selected)) {
                this.textMatcher.setFilterText(new String[]{(String)selected});
            } else {
                this.textMatcher.setFilterText(new String[0]);
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error settings the GL Account Link filter.", (Throwable)ex);
        }
    }

    protected void glCodeEdited(Object edited) {
        this.tableEdited.emit(edited);
    }

    private GLAccount getEmptyGlAccount() {
        if (this.emptyGlAccount == null) {
            this.emptyGlAccount = new GLAccount();
            this.emptyGlAccount.setName("");
        }
        return this.emptyGlAccount;
    }

    private static final class GLLinkCompleteComboCellEditor
    extends AutoCompleteComboCellEditor {
        public GLLinkCompleteComboCellEditor(EventList data, boolean useEmptyVal) {
            super(data, useEmptyVal);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return super.getTableCellEditorComponent(table, value != null ? ((GLAccount)value).getGlCode() : value, isSelected, row, column);
        }
    }

    private static final class ExportTypeFilterator
    implements TextFilterator {
        private ExportTypeFilterator() {
        }

        public void getFilterStrings(List baseList, Object element) {
            baseList.add(((GLCodeLinkReport)element).getExportType().getDescription());
        }
    }

    private static final class GLAccountListRenderer
    extends DefaultListCellRenderer {
        private GLAccountListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value != null && value != EditablePropertyColumnFormat.Empty.NULL && ((GLAccount)value).getGlCode() != null) {
                this.setText(((GLAccount)value).getGlCode() + " - " + ((GLAccount)value).getName());
            } else {
                this.setText(" ");
            }
            return this;
        }
    }

    private static final class ExportTypeCellRenderer
    extends DefaultTableCellRenderer {
        private ExportTypeCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                this.setText("");
            } else {
                this.setText(((AccountingExportType)value).getDescription());
            }
            return this;
        }
    }

    private class GLAccountCellRenderer
    extends DefaultTableCellRenderer {
        private GLAccountCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jtable, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            GLCodeLinkReport test = (GLCodeLinkReport)GLAccountLinkPanel.this.table.getObjectAt(row);
            super.getTableCellRendererComponent(jtable, test.getDisplayableGLAccount(), isSelected, hasFocus, row, column);
            Font existingFont = this.getFont();
            if (test.getGlAccount() == null) {
                Font italicFont = new Font(existingFont.getName(), 2, existingFont.getSize());
                this.setFont(italicFont);
            } else {
                Font plainFont = new Font(existingFont.getName(), 0, existingFont.getSize());
                this.setFont(plainFont);
            }
            return this;
        }
    }
}

