/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.accounting;

import ca.odell.glazedlists.GlazedLists;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import officemate.components.AbstractObjectEditor;
import ordermate.database.finance.tax.TaxCode;
import ordermate.database.integration.accounting.settings.AccountingClassType;
import ordermate.database.integration.accounting.settings.CashFlowClassification;
import ordermate.database.integration.accounting.settings.GLAccount;
import ordermate.gui.FieldPanelBuilder;

public class GLAccountSetupEditor
extends AbstractObjectEditor<GLAccount> {
    public GLAccountSetupEditor() {
        this.setupComponents();
    }

    private void setupComponents() {
        FieldPanelBuilder builder = new FieldPanelBuilder();
        JComboBox typeCombo = this.setupComboBox(GLAccount.Properties.TYPE, GlazedLists.eventList(Arrays.asList(AccountingClassType.values())));
        typeCombo.setRenderer(new TypeRenderer());
        builder.addRow("Type", (Component)typeCombo);
        builder.addRow("Name", (Component)this.setupTextField(GLAccount.Properties.NAME, 20));
        builder.addRow("GL-Code", (Component)this.setupTextField(GLAccount.Properties.GL_CODE, 20));
        builder.addRow("Description", (Component)this.setupTextArea(GLAccount.Properties.DESCRIPTION, 60, 5, null));
        builder.addRow("Exported", (Component)this.setupCheckBox(GLAccount.Properties.EXPORTED));
        builder.addRow("Grouped", (Component)this.setupCheckBox(GLAccount.Properties.GROUPED));
        JComboBox cashFlowCombo = this.setupComboBox(GLAccount.Properties.CASH_FLOW_CLASSIFICATION, GlazedLists.eventList(Arrays.asList(CashFlowClassification.values())));
        cashFlowCombo.setRenderer(new CashFlowClassificationRenderer());
        builder.addRow("Cash Flow Classification", (Component)cashFlowCombo);
        JComboBox taxCodeCombo = this.setupComboBox(GLAccount.Properties.DEFAULT_TAX_CODE, GlazedLists.eventList((Collection)TaxCode.getAllTaxCodes()));
        taxCodeCombo.setRenderer(new TaxCodeRenderer());
        builder.addRow("Default Tax Code", (Component)taxCodeCombo);
        this.add(builder.getPanel());
    }

    private static class CashFlowClassificationRenderer
    extends DefaultListCellRenderer {
        private CashFlowClassificationRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            CashFlowClassification cashFlowClass = null;
            if (value instanceof CashFlowClassification) {
                cashFlowClass = (CashFlowClassification)value;
            }
            return cashFlowClass == null ? new JLabel("") : new JLabel(cashFlowClass.getDisplayableText());
        }
    }

    private static class TaxCodeRenderer
    extends DefaultListCellRenderer {
        private TaxCodeRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            TaxCode taxCode = null;
            if (value instanceof TaxCode) {
                taxCode = (TaxCode)value;
            }
            return taxCode == null ? new JLabel("") : new JLabel(taxCode.getExtAccID());
        }
    }

    private static class TypeRenderer
    extends DefaultListCellRenderer {
        private TypeRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            AccountingClassType accType = null;
            if (value instanceof AccountingClassType) {
                accType = (AccountingClassType)value;
            }
            return accType == null ? new JLabel("") : new JLabel(accType.getDescription());
        }
    }
}

