/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.accounting;

import au.com.ordermate.glazedlists.GlazedListUtils;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import javax.swing.Action;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.adminkit.state.ActionFactory;
import officemate.components.EditorDialog;
import officemate.components.strategy.StrategySaveCancelListener;
import officemate.screens.setup.configuration.accounting.BaseGLAccountOfficeMateState;
import officemate.screens.setup.configuration.accounting.GLAccountSetupEditor;
import officemate.screens.setup.configuration.accounting.GLAccountSetupPanel;
import ordermate.OrderMate;
import ordermate.database.integration.accounting.settings.AccountingClassType;
import ordermate.database.integration.accounting.settings.BaseAccountingConfiguration;
import ordermate.database.integration.accounting.settings.GLAccount;
import ordermate.database.users.AllPermissions;

public class GLAccountSetupState
extends BaseGLAccountOfficeMateState<GLAccount>
implements StrategySaveCancelListener {
    private GLAccountSetupPanel glAccountPanel;
    private EventList<GLAccount> glAccountList = new BasicEventList();
    private EditorDialog editorDialog;
    private GLAccountSetupEditor editor;

    public GLAccountSetupState() {
        super("GL Account Setup", AllPermissions.CONFIG_INTEGRATIONS, "Allows configuring the accounting gl codes.");
        this.glAccountPanel = new GLAccountSetupPanel(this.glAccountList);
        this.glAccountPanel.tableEdited.connect((Object)this, "tableEdited");
        this.setScreenPanel(this.glAccountPanel);
        this.addActions();
        this.editor = new GLAccountSetupEditor();
        this.editorDialog = new EditorDialog("GL Account", this.editor);
        this.getSaveStrategy().addSaveCancelListener(this);
        this.addAction((Action)ActionFactory.createPermissibleNewAction(this, AllPermissions.CONFIG_INTEGRATIONS));
    }

    private void addActions() {
        this.glAccountPanel.getTable().addSelectionDependentAction(this.getDeleteAction());
        this.glAccountPanel.getTable().addSelectionDependentAction(this.getEditAction());
    }

    @Override
    public void refresh() {
        super.refresh();
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.glAccountList, PersistenceManager.getObjectList(GLAccount.class, (String)Query.select(GLAccount.class).toString()));
    }

    public void tableEdited(Object object) {
        this.getSaveStrategy().objectNeedsSaving((GLAccount)object);
    }

    private boolean showDialog(GLAccount glAccount) {
        this.editor.setObject(glAccount);
        if (this.editorDialog.doModal()) {
            this.editor.saveObject();
            GLAccount toSave = (GLAccount)this.editor.getObject();
            try {
                this.tableEdited(toSave);
                GlazedListUtils.replace(this.glAccountList, (Object)glAccount, (Object)toSave);
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Could not save GL Account: " + toSave, (Throwable)ex);
            }
        } else {
            this.editor.revertObject();
        }
        return this.editorDialog.getOkClicked();
    }

    @Override
    public void preSave() {
    }

    @Override
    public void preCancel() {
    }

    @Override
    public void postSave() {
        BaseAccountingConfiguration.getInstance().clearCache();
    }

    @Override
    public void doNewAction() {
        GLAccount newGLAccount = new GLAccount();
        newGLAccount.setType(AccountingClassType.OTHER);
        newGLAccount.setExported(true);
        if (this.showDialog(newGLAccount)) {
            this.glAccountList.add((Object)newGLAccount);
        }
    }

    @Override
    public void doEditAction() {
        this.showDialog(this.glAccountPanel.getSelected());
    }

    @Override
    public void doDeleteAction() {
        this.getSaveStrategy().objectNeedsDeleting(this.glAccountPanel.getSelected());
        this.glAccountList.remove((Object)this.glAccountPanel.getSelected());
    }
}

