/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.actions;

import au.com.ordermate.persistence.PropertiedObject;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.Component;
import java.util.Collection;
import javax.swing.JScrollPane;
import officemate.components.AbstractObjectEditor;
import officemate.components.ChooseListElementsObjectEditor;
import officemate.components.VariBindings;
import officemate.screens.setup.configuration.webservice.WebserviceConfigSetupEditor;
import ordermate.database.integration.webservice.WebserviceIntegrationConfig;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.misc.action.ActionFireOn;
import ordermate.database.misc.action.ActionOperatorFactory;
import ordermate.database.misc.action.ActionPushType;
import ordermate.database.misc.action.ConfigAccountAction;
import ordermate.database.misc.action.ConfigAction;
import ordermate.database.misc.action.ConfigButtonAction;
import ordermate.database.misc.action.ConfigTimerAction;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.binding.validators.NotEmptyValidator;
import org.jdesktop.beansbinding.Validator;

class ConfigActionEditor
extends AbstractObjectEditor<ConfigAction> {
    private WebserviceConfigSetupEditor webConfigEditor;
    private ActionTriggerLinkEditor triggerLinks;
    private EventList<AbstractTrigger> triggers;
    private VariBindings variBindings;

    ConfigActionEditor() {
        this.setupComponents();
    }

    private void setupComponents() {
        FieldPanelBuilder builder = new FieldPanelBuilder();
        builder.addRow("Label", (Component)this.setupTextField(ConfigAction.Properties.LABEL, 20, (Validator)new NotEmptyValidator()));
        builder.addRow("Sequence", (Component)this.setupIntSpinner(ConfigAction.Properties.SEQUENCE, 1, 0, Integer.MAX_VALUE, 1, 3));
        builder.addRow("Payload", (Component)this.setupTextArea(ConfigAction.Properties.PAYLOAD, 40, 3, null), this.makePayloadToolTip());
        builder.addRow("Push Type", (Component)this.setupComboBox(ConfigAction.Properties.PUSH_TYPE, GlazedLists.eventListOf((Object[])ActionPushType.values())));
        builder.addRow("Timer Seconds", (Component)this.setupIntSpinner(ConfigTimerAction.Properties.TIMER_SECONDS, 10, Integer.MAX_VALUE, 1, 30, 10));
        builder.addRow("Icon", (Component)this.setupTextField(ConfigButtonAction.Properties.ICON, 40));
        builder.addRow("Fire On", (Component)this.setupComboBox(ConfigAccountAction.Properties.FIRE_ON, GlazedLists.eventListOf((Object[])ActionFireOn.values())));
        this.webConfigEditor = new WebserviceConfigSetupEditor(builder, this.getListener(), this.getBindings(), (PropertiedObject.Property<WebserviceIntegrationConfig>)ConfigAction.Properties.WEB_CONFIG);
        builder.addRow((Component)this.webConfigEditor);
        this.variBindings = new VariBindings(this.getBindings(), ConfigTimerAction.Properties.TIMER_SECONDS, ConfigButtonAction.Properties.ICON, ConfigAccountAction.Properties.FIRE_ON);
        this.add(builder.getPanel());
        this.triggers = GlazedLists.eventList((Collection)AbstractTrigger.getUserLinkableTriggers());
        this.triggerLinks = new ActionTriggerLinkEditor(this.triggers);
        this.add(new JScrollPane(this.triggerLinks));
    }

    @Override
    public void refresh() {
        super.refresh();
        this.triggers = GlazedLists.eventList((Collection)AbstractTrigger.getUserLinkableTriggers());
    }

    @Override
    public void setObject(ConfigAction action) {
        super.setObject(action);
        this.variBindings.setObject(action);
    }

    private String makePayloadToolTip() {
        StringBuilder SB = new StringBuilder("<html><h1>Payload Patterns</h1>");
        SB.append("~").append(" separates keys from values.<br>");
        SB.append("New lines will separate pairs.<br>{ ... } denotes an object property.<br>");
        SB.append("account, customer, terminal, user<br><br>");
        SB.append("For example:<br>\r\n");
        SB.append("\"total\"~round({account.savedTotal}, 0)<br>");
        SB.append("\"name\"~{user.firstName}<br>");
        SB.append("\"static\"~\"text\"<br>");
        SB.append("will give a url of<br> ...:4321/context?total=24.75&user=Fred&static=true<br><br>\r\n");
        SB.append("Operations inlude:<ul>");
        for (String op : new ActionOperatorFactory().getOperators()) {
            SB.append("<li>").append(op).append("</li>\r\n");
        }
        SB.append("<br>");
        SB.append("<h2>Entities</h2>To marshall an entity, enclose the keyword in a hash, thus: #account#<br><br>");
        SB.append("Note that currently only BarTabs are supported.");
        return SB.toString();
    }

    class ActionTriggerLinkEditor
    extends ChooseListElementsObjectEditor<ConfigAction, AbstractTrigger> {
        public ActionTriggerLinkEditor(EventList<AbstractTrigger> thePossibleElements) {
            super(thePossibleElements);
        }

        @Override
        public void addObjectToParent(AbstractTrigger toAdd) {
            ((ConfigAction)this.getObject()).addTrigger(toAdd);
        }

        @Override
        public void removeObjectFromParent(AbstractTrigger toRemove) {
            ((ConfigAction)this.getObject()).removeTrigger(toRemove);
        }

        @Override
        public Collection<AbstractTrigger> getParentList() {
            return ((ConfigAction)this.getObject()).getTriggers();
        }
    }
}

