/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.advanced;

import au.com.ordermate.gui.adminkit.ComponentUtils;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.util.Price;
import ca.odell.glazedlists.GlazedLists;
import java.awt.Component;
import java.util.HashMap;
import javax.swing.Action;
import javax.swing.JComboBox;
import officemate.components.AbstractObjectEditor;
import officemate.components.ObjectEditorState;
import officemate.components.internationalization.RegionChangerComboBox;
import officemate.components.strategy.SaveStrategyFactory;
import ordermate.database.misc.BusinessInfo;
import ordermate.database.sales.CustomerSearch;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.Permission;
import ordermate.gui.FieldPanelBuilder;
import ordermate.internationalization.Internationalization;
import org.jdesktop.beansbinding.AutoBinding;

public class BusinessInfoState
extends ObjectEditorState {
    private BusinessInfo instance;
    private static final String BUSINESS_NAME = "Business Name";
    private static final String BUSINESS_Number = "Business Number";

    public BusinessInfoState() {
        super("Business Info", AllPermissions.ACCESS_BUSINESS_INFO, "Allows the user to modify the business information");
        this.setSaveStrategy(SaveStrategyFactory.getDeferredSaveStrategy((Refreshable)this));
        HashMap<String, Permission> itemPermissionMap = new HashMap<String, Permission>();
        itemPermissionMap.put(BUSINESS_NAME, AllPermissions.ACCESS_BUSINESS_NAME_NUMBER);
        itemPermissionMap.put(BUSINESS_Number, AllPermissions.ACCESS_BUSINESS_NAME_NUMBER);
        this.setItemsPermission(itemPermissionMap);
        this.addAction((Action)new RefreshAction((Refreshable)this));
    }

    protected Object acquireObject() {
        if (this.instance == null) {
            this.instance = BusinessInfo.getInstance();
        }
        return this.instance;
    }

    protected AbstractObjectEditor createObjectEditor() {
        return new BusinessInfoEditor();
    }

    class BusinessInfoEditor
    extends AbstractObjectEditor {
        BusinessInfoEditor() {
            this.getBindings().setStrategy(AutoBinding.UpdateStrategy.READ_WRITE);
            this.setupComponents();
        }

        public void setupComponents() {
            FieldPanelBuilder builder = new FieldPanelBuilder();
            if (BusinessInfoState.this.getItemVisibility(BusinessInfoState.BUSINESS_NAME).equals("ENABLED")) {
                builder.addRow(BusinessInfoState.BUSINESS_NAME, (Component)this.setupTextField(BusinessInfo.Properties.NAME, 20));
            }
            if (BusinessInfoState.this.getItemVisibility(BusinessInfoState.BUSINESS_Number).equals("ENABLED")) {
                builder.addRow(BusinessInfoState.BUSINESS_Number, (Component)this.setupTextField(BusinessInfo.Properties.ABN, 20));
            }
            builder.addRow("Business Number Type", (Component)this.setupTextField(BusinessInfo.Properties.BUSINESS_NUMBER_TYPE, 20), "The business number type for your country/region: ABN, NZBN, RN etc.");
            if (Internationalization.getActiveResourceBundleForMoney().getLocale().toString().equals("en_NZ")) {
                builder.addRow("GST Number", (Component)this.setupTextField(BusinessInfo.Properties.GST_NUM, 20), "For New Zealand only.");
            }
            builder.addRow("Telephone", (Component)this.setupTextField(BusinessInfo.Properties.PHONE, 20));
            builder.addRow("Business Location", (Component)this.setupTextField(BusinessInfo.Properties.LOCATION, 40));
            builder.addRow("Address 1", (Component)this.setupTextField(BusinessInfo.Properties.ADDRESS1, 40));
            builder.addRow("Address 2", (Component)this.setupTextField(BusinessInfo.Properties.ADDRESS2, 40));
            builder.addRow("Message", (Component)this.setupTextField(BusinessInfo.Properties.MESSAGE, 40));
            RegionChangerComboBox countryComboBox = new RegionChangerComboBox();
            ComponentUtils.setupComboBox((JComboBox)countryComboBox);
            countryComboBox.setName("countryComboBox");
            builder.addRow("Country", (Component)countryComboBox);
            String stateText = "State";
            if (Internationalization.getActiveResourceBundleForMoney().getLocale().toString().equals("en_GB")) {
                stateText = "County";
            }
            builder.addRow(stateText, (Component)this.setupComboBox(BusinessInfo.Properties.DEFAULT_STATE, GlazedLists.eventListOf((Object[])CustomerSearch.getStates())));
            builder.addRow("Number Of Delivery Phone Lines", (Component)this.setupIntSpinner(BusinessInfo.Properties.NUMBER_OF_LINES, 1, 0, 255, 0, 4));
            builder.addRow("Phone Area Code Prefix", (Component)this.setupTextField(BusinessInfo.Properties.PHONE_AREA_CODE_PREFIX, 10));
            builder.addRow("Default Float Amount", (Component)this.setupPriceField((PropertiedObject.Property<Price>)BusinessInfo.Properties.DEFAULT_FLOAT_AMOUNT, 10));
            builder.addRow("Logo", (Component)this.setupTextField(BusinessInfo.Properties.LOGO, 40));
            builder.addRow("Label Logo", (Component)this.setupTextField(BusinessInfo.Properties.LABEL_LOGO, 40));
            builder.addRow("Label Report", (Component)this.setupTextField(BusinessInfo.Properties.LABEL_REPORT, 40));
            builder.addRow("Docket Hour Format", (Component)this.setupComboBox(BusinessInfo.Properties.DOCKET_HOUR_FORMAT, GlazedLists.eventListOf((Object[])new String[]{"24h", "12h"})));
            builder.addRow("Menu Import FTP User", (Component)this.setupTextField(BusinessInfo.Properties.MENU_IMPORT_FTP_USER, 40));
            builder.addRow("Menu Import FTP Password", (Component)this.setupTextField(BusinessInfo.Properties.MENU_IMPORT_FTP_PASSWORD, 40));
            builder.addRow("Menu Import FTP Server", (Component)this.setupTextField(BusinessInfo.Properties.MENU_IMPORT_FTP_SERVER, 40));
            builder.addRow("Menu Import FTP Folder", (Component)this.setupTextField(BusinessInfo.Properties.MENU_IMPORT_FTP_FOLDER, 40));
            this.add(builder.getPanel());
        }
    }
}

