/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.advanced;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.AbstractObjectEditor;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.gui.FieldPanelBuilder;
import ordermate.integration.cloudback.redback.RedBackClient;
import org.jdesktop.beansbinding.AutoBinding;

public class CurrentInfoSetupEditor
extends AbstractObjectEditor<SystemCurrentInfo>
implements ActionListener {
    private JButton updateRedbackIdBut;
    private JFormattedTextField updatemateIdField;
    private JFormattedTextField redbackIdField;

    public CurrentInfoSetupEditor(String editable) {
        if (!editable.equals("ENABLED")) {
            this.updateRedbackIdBut.setEnabled(false);
            this.updatemateIdField.setEnabled(false);
            this.redbackIdField.setEnabled(false);
        }
    }

    @Override
    protected void init() {
        super.init();
        this.getBindings().setStrategy(AutoBinding.UpdateStrategy.READ_WRITE);
        FieldPanelBuilder leftBuilder = new FieldPanelBuilder();
        FieldPanelBuilder rightBuilder = new FieldPanelBuilder();
        this.updatemateIdField = this.setupLongField(SystemCurrentInfo.Properties.UPDATEMATE_ID, 10, null, null);
        leftBuilder.addRow("UpdateMate ID", (Component)this.updatemateIdField, "Set the UpdateMate ID for the store.");
        this.updateRedbackIdBut = new JButton("Update RedBack ID");
        leftBuilder.addRow("", (Component)this.updateRedbackIdBut, "Fetches the RedBack ID from RedBack using the UpdateMate ID in the field above.");
        this.redbackIdField = this.setupLongField(SystemCurrentInfo.Properties.REDBACK_ID, 10, null, null);
        this.redbackIdField.setEditable(false);
        leftBuilder.addRow("RedBack ID", (Component)this.redbackIdField, "The RedBack ID for the store. This field is not editable, you can only update it by clicking the button above, or editing the database directly.");
        this.setLayout(new BorderLayout());
        this.add("West", leftBuilder.getPanel());
        this.add("East", rightBuilder.getPanel());
        this.updateRedbackIdBut.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.updateRedbackIdBut) {
            this.updateRedbackId();
        }
    }

    private void updateRedbackId() {
        RedBackClient rbClient = new RedBackClient();
        String udpatemateId = this.updatemateIdField.getText();
        Long id = null;
        try {
            id = rbClient.getRedBackId(Long.valueOf(udpatemateId).longValue());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (id == null) {
            Dialogs.showInfoDialog("Get RedBack ID info", "Could not retrieve RedBack ID from RedBack using UpdateMate ID: '" + udpatemateId + "'. Remember, it has to be a number!");
        } else {
            this.redbackIdField.setValue(id);
        }
    }
}

