/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.advanced;

import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.persistence.Executable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.image.IconLoader;
import groovy.lang.Closure;
import groovy.lang.GroovyClassLoader;
import groovy.ui.Console;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JPanel;
import officemate.adminkit.state.BasicOfficeMateState;
import ordermate.database.users.AllPermissions;
import ordermate.services.misc.CallMethodOnClassExecutable;

public class GroovyConsoleState
extends BasicOfficeMateState {
    private Console console;

    public GroovyConsoleState() {
        super("Dev Console", AllPermissions.GOD_ONLY, "Execute groovy scripts... DEVELOPERS ONLY!");
        this.addAction((Action)((Object)new LaunchAction()));
        this.addAction((Action)((Object)new UpdateMateScriptAction()));
    }

    @Override
    public void onStart() {
        if (this.isFirstRun()) {
            this.createGroovyConsole();
            this.setScreenPanel(new JPanel());
        }
    }

    private void createGroovyConsole() {
        this.console = new Console((ClassLoader)new GroovyClassLoader(this.getClass().getClassLoader()));
        this.console.setVisualizeScriptResults(true);
        this.console.setBeforeExecution((Closure)new BeforeScriptExcecutionCheckClosure(this.console));
        this.console.run();
    }

    private static final class IllegalGroovyScriptException
    extends RuntimeException {
        public IllegalGroovyScriptException(String message) {
            super(message);
        }
    }

    public static final class BeforeScriptExcecutionCheckClosure
    extends Closure {
        private static final String[] NON_ALLOWED_REFERENCES = new String[]{"PersistentLicenseChecker", "PersistentLicenseManager", "LicenseHelper", "License"};

        public BeforeScriptExcecutionCheckClosure(Object owner, Object thisObject) {
            super(owner, thisObject);
        }

        public BeforeScriptExcecutionCheckClosure(Object owner) {
            super(owner);
        }

        public void doCall() {
            String scriptToRun = ((Console)this.getOwner()).getInputArea().getText();
            for (int i = 0; i < NON_ALLOWED_REFERENCES.length; ++i) {
                if (!scriptToRun.contains(NON_ALLOWED_REFERENCES[i])) continue;
                throw new IllegalGroovyScriptException("Script can not be run as it contains illegal code references.");
            }
        }
    }

    private class UpdateMateScriptAction
    extends BasicAction {
        UpdateMateScriptAction() {
            super("Run Updatemate Script", (Icon)IconLoader.get((String)"/ordermate/images/edit_icon16.png"));
        }

        public void actionPerformed(ActionEvent e) {
            PersistenceManager.getServerConnection().runSync((Executable)new CallMethodOnClassExecutable("servermate.scripts.UpdateMateScriptFileWatchTask", new String[]{"getInstance", "runNow"}));
        }
    }

    private class LaunchAction
    extends BasicAction {
        LaunchAction() {
            super("Launch Console", (Icon)IconLoader.get((String)"/ordermate/images/new_icon16.png"));
        }

        public void actionPerformed(ActionEvent e) {
            GroovyConsoleState.this.createGroovyConsole();
        }
    }
}

