/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.advanced;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DecimalFormat;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.NumberFormatter;
import officemate.components.AbstractObjectEditor;
import ordermate.OrderMate;
import ordermate.database.misc.HOConfig;
import ordermate.database.misc.StoreGroup;
import ordermate.gui.FieldPanelBuilder;

class HOConfigEditor
extends AbstractObjectEditor<HOConfig> {
    private JLabel lastCustomerUpdateLabel;
    private JLabel timeDifferenceLabel;
    private JSpinner storeIdField;
    private JLabel lastMenuImportTimeLabel;
    private JTextField storeNameField;

    HOConfigEditor() {
        this.setupComponents();
    }

    private void setupComponents() {
        this.setLayout(new FlowLayout(0));
        FieldPanelBuilder builder = new FieldPanelBuilder();
        JComponent component = this.setupCheckBox(HOConfig.Properties.ENABLED);
        builder.addRow("Is Enabled?", (Component)component);
        component = this.setupTextField(HOConfig.Properties.SERVER_LOCATION, 30);
        builder.addRow("Server Location", (Component)component);
        this.lastCustomerUpdateLabel = new JLabel();
        this.timeDifferenceLabel = new JLabel();
        this.lastMenuImportTimeLabel = new JLabel();
        builder.addRow("Time Difference (ms)", (Component)this.timeDifferenceLabel);
        builder.addRow("Last Customer Update", (Component)this.lastCustomerUpdateLabel);
        builder.addRow("Last Menu Import", (Component)this.lastMenuImportTimeLabel);
        JSpinner delaySpinner = this.setupIntSpinner(HOConfig.Properties.SYNC_SEND_DELAY_MS, 5, 0, 2000, 25, 6);
        delaySpinner.setToolTipText("<HTML>This value controls the delay between sending synchronisation messages<BR>increase this value if the server is running at high CPU rates to throttle the sync thread.");
        builder.addRow("Sync message delay (ms)", (Component)delaySpinner);
        builder.addRow("Menu Master Site", (Component)this.setupCheckBox(HOConfig.Properties.MENU_MASTER_SITE));
        builder.addRow("Multisite Customers", (Component)this.setupCheckBox(HOConfig.Properties.MULTISITE_CUSTOMERS));
        builder.addRow("Ignore Existing Prices On Import", (Component)this.setupCheckBox(HOConfig.Properties.IGNORE_PRICES_ON_IMPORT));
        long value = 0L;
        try {
            value = StoreGroup.getInstance().getStoreId();
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("Problem with the store number", (Throwable)ex);
        }
        this.storeIdField = new JSpinner(new SpinnerNumberModel(value, 0.0, 99999.0, 1.0));
        ((NumberFormatter)((JSpinner.DefaultEditor)this.storeIdField.getEditor()).getTextField().getFormatter()).setFormat(new DecimalFormat("0"));
        this.storeIdField.addChangeListener(this.createStoreIdChangeListener());
        builder.addRow("Store ID", (Component)this.storeIdField);
        this.storeNameField = new JTextField(StoreGroup.getInstance().getStoreName(), 30);
        this.storeNameField.addActionListener(this.createStoreNameChangeListener());
        this.storeNameField.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                StoreGroup.getInstance().setStoreName(HOConfigEditor.this.storeNameField.getText());
                StoreGroup.getInstance().save();
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        this.storeNameField.isValid();
        builder.addRow("Store Name", (Component)this.storeNameField);
        builder.addRow("HO Lite", (Component)this.setupCheckBox(HOConfig.Properties.HO_LITE));
        this.add(builder.getPanel());
    }

    @Override
    public void setObject(HOConfig config) {
        try {
            super.setObject(config);
            this.lastCustomerUpdateLabel.setText(String.valueOf(config.getLastCustomerUpdate()));
            this.timeDifferenceLabel.setText(String.valueOf(config.getTimeDifference()));
            this.lastMenuImportTimeLabel.setText(config.getLastMenuImportTime() != null ? String.valueOf(config.getLastMenuImportTime()) : "None");
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("Problem with setting the HOConfig", (Throwable)ex);
        }
    }

    private ChangeListener createStoreIdChangeListener() {
        return new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    StoreGroup.getInstance().setStoreId(Long.valueOf(((Number)HOConfigEditor.this.storeIdField.getValue()).longValue()));
                    StoreGroup.getInstance().save();
                }
                catch (Exception ex) {
                    OrderMate.LOG.warn("Problem with setting the store id", (Throwable)ex);
                }
            }
        };
    }

    private ActionListener createStoreNameChangeListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StoreGroup.getInstance().setStoreName(HOConfigEditor.this.storeNameField.getText());
                StoreGroup.getInstance().save();
            }
        };
    }
}

