/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.advanced;

import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.image.IconLoader;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.Icon;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.AbstractObjectEditor;
import officemate.components.ObjectEditorState;
import officemate.screens.setup.configuration.advanced.HOConfigEditor;
import ordermate.database.misc.HOConfig;
import ordermate.jaxb.exporter.handlers.posdatabase.PosXMLIntegrator;

public class HOConfigState
extends ObjectEditorState<HOConfig> {
    private HOConfigEditor objectEditor;

    public HOConfigState() {
        super("Head Office Configuration", null, "Configure parameters relating to HeadOffice integration");
        this.addAction((Action)((Object)new GenerateMasterIDs()));
    }

    @Override
    protected HOConfig acquireObject() {
        return HOConfig.getInstance();
    }

    @Override
    protected AbstractObjectEditor<HOConfig> createObjectEditor() {
        this.objectEditor = new HOConfigEditor();
        return this.objectEditor;
    }

    @Override
    public void gotObjectEdited() {
        this.objectEditor.saveObject();
        ((HOConfig)this.objectEditor.getObject()).save();
    }

    private class GenerateMasterIDs
    extends BasicAction {
        public GenerateMasterIDs() {
            super("Generate IDs", (Icon)IconLoader.get((String)"/ordermate/images/export_regenerate.png"), "<HTML>Generate Master IDs for the menu, this will create master IDs for any that do not have them.<BR><BR><B>Warning:</B> After performing this action the menu will not be able to be merged<BR>with another menu that has different master IDs</HTML>");
        }

        public void actionPerformed(ActionEvent e) {
            if (!Dialogs.showChoiceDialog("Generate Master IDs", "<HTML>Are you sure you want to generate master IDs?<BR><BR>Once this has been performed you will be <B>unable to merge</B><BR>this menu with another menu with different master IDs</HTML>")) {
                return;
            }
            PosXMLIntegrator integrator = new PosXMLIntegrator(null, PersistenceManager.getPersistenceDelegate());
            if (integrator.generateMasterIDs()) {
                Dialogs.showInfoDialog("Success", "Successfully generated master IDs");
            } else {
                Dialogs.showErrorDialog("Error", "Could not generate master IDs, check the logs for more information");
            }
        }
    }
}

