/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.advanced.appconfig;

import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.persistence.Executable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.image.IconLoader;
import ca.odell.glazedlists.EventList;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingWorker;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.screens.setup.configuration.advanced.appconfig.AppConfigEditorPanel;
import ordermate.database.misc.application.Application;
import ordermate.database.misc.application.ApplicationConfig;
import ordermate.jnlp.CreateJNLPExecutable;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class ApplicationConfigState
extends AbstractEditableTableState<ApplicationConfig> {
    private Action createJNLP;
    private Action suggestedValuesAction;

    public ApplicationConfigState() {
        super("Application Config", null, "Modify application specific configurations, like the jnlp.");
    }

    @Override
    protected void init() {
        if (this.initCalled) {
            return;
        }
        super.init();
        this.createJNLP = new AbstractAction("Create JNLP", IconLoader.get((String)"/ordermate/images/export_regenerate.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationConfigState.this.exportJNLP();
            }
        };
        this.addAction(this.createJNLP);
        this.suggestedValuesAction = new AbstractAction("Suggested Values", IconLoader.get((String)"/ordermate/images/info.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationConfigState.this.showSuggestedValues();
            }
        };
        this.addAction(this.suggestedValuesAction);
    }

    private void showSuggestedValues() {
        StringBuilder SB = new StringBuilder("<html><body><h2>Suggested Memory Values</h2>");
        SB.append("Below are suggested starting and maximum memory allocations. Use as a guide only.");
        SB.append("<table><th>Application</th><th>System Memory (MB)</th><th>Starting Memory (MB)</th><th>Maximum Memory (MB)</th>");
        String sys512 = " 512";
        String sys1GB = " 1024";
        String sys2GB = " 2048+";
        String sysDef = "Default";
        this.appendSuggestedRow(SB, Application.Servermate, " 512", 55, 120);
        this.appendSuggestedRow(SB, Application.Servermate, " 1024", 120, 150);
        this.appendSuggestedRow(SB, Application.Servermate, " 2048+", 250, 300);
        this.appendSuggestedRow(SB, Application.Waitermate, " 512", 100, 180);
        this.appendSuggestedRow(SB, Application.Waitermate, " 1024", 180, 250);
        this.appendSuggestedRow(SB, Application.Waitermate, " 2048+", 250, 300);
        this.appendSuggestedRow(SB, Application.Officemate, " 512", 32, 150);
        this.appendSuggestedRow(SB, Application.Officemate, " 1024", 100, 150);
        this.appendSuggestedRow(SB, Application.Officemate, " 2048+", 150, 250);
        this.appendSuggestedRow(SB, Application.TouchPrepXPress, " 512", 150, 200);
        this.appendSuggestedRow(SB, Application.TouchPrepXPress, " 1024", 250, 500);
        SB.append("</table></html>");
        Dialogs.showInfoDialog("Suggested Values", SB.toString());
    }

    private void appendSuggestedRow(StringBuilder SB, Application app, String sysMem, int startMem, int maxMem) {
        SB.append("<tr><td>").append(app.name()).append("</td><td>").append(sysMem).append("</td><td>").append(startMem).append("</td><td>").append(maxMem).append("</td></tr>");
    }

    private void exportJNLP() {
        StringBuilder SB = new StringBuilder("Are you sure you wish to export the jnlp files?\n\n");
        SB.append("Any current jnlp files will be overwritten.");
        if (Dialogs.showChoiceDialog("Confirm JNLP export", SB.toString())) {
            EventList configs = this.getObjectList();
            configs.getReadWriteLock().readLock().lock();
            final ApplicationConfig[] configArray = (ApplicationConfig[])configs.toArray((Object[])new ApplicationConfig[configs.size()]);
            configs.getReadWriteLock().readLock().unlock();
            new SwingWorker(){

                protected Object doInBackground() throws Exception {
                    PersistenceManager.getServerConnection().runSync((Executable)new CreateJNLPExecutable(configArray, true));
                    return null;
                }

                @Override
                public void done() {
                    try {
                        this.get();
                    }
                    catch (Exception ex) {
                        Dialogs.showErrorDialog("Could not produce jnlp", "<HTML>An error occurred creating the jnlp:<BR>" + ex.getMessage() + "</HTML>");
                    }
                }
            }.run();
        }
    }

    @Override
    protected boolean canCreateOrDelete() {
        return false;
    }

    @Override
    protected ObjectEditor createObjectEditor() {
        return new AppConfigEditorPanel();
    }

    @Override
    public String getTypeName() {
        return "Applicaton Configuration";
    }

    @Override
    protected TableStateCentralArea<ApplicationConfig> createCentralArea() {
        ColumnTableFormat format = new ColumnTableFormat(new ColumnFormat[]{new PropertyColumnFormat(ApplicationConfig.Properties.APPLICATION), new PropertyColumnFormat(ApplicationConfig.Properties.STARTING_MEMORY), new PropertyColumnFormat(ApplicationConfig.Properties.MAXIMUM_MEMORY)});
        PersistentObjectTable<ApplicationConfig> area = new PersistentObjectTable<ApplicationConfig>(this.getObjectList(), format);
        return area;
    }

    @Override
    protected Class<ApplicationConfig> getDisplayingType() {
        return ApplicationConfig.class;
    }
}

