/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.advanced.cloudback;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.persistence.PropertiedObject;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import officemate.components.tableformat.EditablePropertyColumnFormat;
import ordermate.database.integration.cloudback.CloudBackConfig;
import ordermate.database.integration.cloudback.CloudServerType;
import ordermate.database.integration.cloudback.NudgeBackConfiguration;
import ordermate.database.misc.SystemCurrentInfo;

public class CloudBackEnabledEditor
extends EditablePropertyColumnFormat {
    public CloudBackEnabledEditor(PropertiedObject.Property prop) {
        super(prop);
    }

    @Override
    public Object setValue(Object baseObject, Object editedValue) {
        long storeId = SystemCurrentInfo.getInstance().getRedbackId();
        if (storeId == 0L) {
            this.showMessage("Cloud Server Store Id is not set.  Please set it to proceed");
            return baseObject;
        }
        CloudBackConfig config = (CloudBackConfig)baseObject;
        Boolean enabled = (Boolean)editedValue;
        this.performConfiguration(config, enabled);
        return super.setValue(baseObject, editedValue);
    }

    private void performNudgeConfiguration(CloudBackConfig config, boolean enable) {
        config.setStoreId(Long.valueOf(SystemCurrentInfo.getInstance().getRedbackId()));
        NudgeBackConfiguration configuration = new NudgeBackConfiguration(config, CloudServerType.Nudge);
        if (configuration.performConfiguration()) {
            this.showMessage("Configuration successfully " + this.getMessage(enable));
        } else {
            this.showMessage(configuration.getErrorMessage());
        }
    }

    private String getMessage(boolean enabled) {
        return enabled ? "enabled" : "disabled";
    }

    private void performConfiguration(CloudBackConfig config, boolean enable) {
        switch (config.getCloudServerType()) {
            case Nudge: {
                this.performNudgeConfiguration(config, enable);
            }
        }
    }

    private void showMessage(String message) {
        JFrame frame = GuiApp.getAppComplex().getApplicationFrame().getFrame();
        JOptionPane.showMessageDialog(frame, message);
    }
}

