/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.advanced.cloudback;

import au.com.ordermate.util.StringUtils;
import au.com.ordermate.xmlintegration.omni.OmniBackRequirement;
import au.com.ordermate.xmlintegration.omni.OmniBackRequirements;
import au.com.ordermate.xmlintegration.omni.OmniBackRequirementsType;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import officemate.adminkit.dialogs.Dialogs;
import ordermate.OrderMate;
import ordermate.database.integration.cloudback.CloudBackConfig;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.inventory.InventoryProfileHelper;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.integration.cloudback.CloudIntegrationUtil;
import ordermate.integration.humpy.HumpBackIntegration;

public class CloudMenuAction
extends AbstractAction {
    private long redbackId = SystemCurrentInfo.getInstance().getRedbackId();
    private static final String PROFILE = "profileId";
    private static final String PRICE_LEVEL = "priceLevelId";

    public CloudMenuAction() {
        super("Setup Cloud Online Ordering");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.startConfiguration();
    }

    private void startConfiguration() {
        CloudBackConfig config = HumpBackIntegration.getHumpBackConfig();
        if (!this.preflightCheck(config)) {
            return;
        }
        OmniBackRequirements reqs = null;
        try {
            reqs = CloudIntegrationUtil.getRequirementTypes((CloudBackConfig)config, (long)this.redbackId);
        }
        catch (Exception ex) {
            Dialogs.showWarningDialog("Cannot continue", ex.getMessage());
            return;
        }
        if (reqs == null) {
            Dialogs.showWarningDialog("Cloud Menu Manager Unreachable", "Cloud Menu Manager could not be reached.");
            return;
        }
        List types = reqs.getReqTypes();
        if (types.isEmpty()) {
            Dialogs.showWarningDialog("Cloud Menu Manager Misconfigured", "There are no Online Menu Consumers");
            return;
        }
        OmniBackRequirementsType type = null;
        if (types.size() == 1) {
            type = (OmniBackRequirementsType)types.get(0);
        } else {
            ArrayList<String> options = new ArrayList<String>();
            for (OmniBackRequirementsType nextType : types) {
                options.add(nextType.getLabel());
            }
            String option = (String)Dialogs.showOptionDialog("Choose the Type", "Please select the type to configure", options);
            for (OmniBackRequirementsType nextType : types) {
                if (!nextType.getLabel().equals(option)) continue;
                type = nextType;
            }
        }
        this.gotType(type);
    }

    public void gotType(OmniBackRequirementsType type) {
        if (type == null) {
            return;
        }
        Dialogs.showInfoDialog("Online Ordering " + type.getLabel(), "This will set up " + type.getLabel() + ", " + type.getDescription());
        OmniBackRequirements reqs = null;
        try {
            reqs = CloudIntegrationUtil.getRequirementsForType((CloudBackConfig)HumpBackIntegration.getHumpBackConfig(), (long)this.redbackId, (OmniBackRequirementsType)type);
        }
        catch (Exception ex) {
            Dialogs.showWarningDialog("Cloud Menu Manager Error", ex.getMessage());
        }
        if (reqs == null) {
            Dialogs.showWarningDialog("Cloud Menu Manager Unreachable", "Cloud Menu Manager could not be reached.");
            return;
        }
        reqs.setStoreId(SystemCurrentInfo.getInstance().getRedbackId());
        reqs.setTypeValue(type.getValue());
        InventoryProfile profile = null;
        PriceLevel level = null;
        for (OmniBackRequirement nextReq : reqs.getRequirements()) {
            if (PROFILE.equals(nextReq.getProperty())) {
                Vector profiles = InventoryProfileHelper.getInstance().getAllProfiles();
                profile = profiles.size() == 1 ? (InventoryProfile)profiles.get(0) : (InventoryProfile)Dialogs.showOptionDialog("Profile", "Select the menu profile to use", profiles);
                if (profile == null) break;
                nextReq.setValue("" + profile.getID());
                continue;
            }
            if (PRICE_LEVEL.equals(nextReq.getProperty())) {
                List levels = PriceLevel.getAllPriceLevels();
                level = levels.size() == 1 ? (PriceLevel)levels.get(0) : (PriceLevel)Dialogs.showOptionDialog("Price Level", "Select the price level to use", levels);
                if (level == null) break;
                nextReq.setValue("" + level.getID());
                continue;
            }
            String input = JOptionPane.showInputDialog("Please provide the " + nextReq.getLabel() + "\r\n" + nextReq.getDescription(), (Object)nextReq.getValue());
            nextReq.setValue(input);
        }
        if (level != null && profile != null) {
            WebResource reqWebservice = HumpBackIntegration.getHumpySyncWebResource((String)"common/storereq");
            try {
                ClientResponse response = (ClientResponse)((WebResource.Builder)reqWebservice.header("Content-Type", (Object)"application/xml").header("Accept", (Object)"application/xml")).post(ClientResponse.class, (Object)CloudIntegrationUtil.marshal((OmniBackRequirements)reqs));
                String entity = (String)response.getEntity(String.class);
                if (response.getStatus() / 100 == 2) {
                    StringBuilder SB = new StringBuilder("<html>Online Config for ").append(type.getValue()).append("<br>");
                    SB.append("Profile:").append(profile).append("<br>");
                    SB.append("Price Level: ").append(level).append("<br>");
                    for (OmniBackRequirement nextReq : reqs.getRequirements()) {
                        if (PROFILE.equals(nextReq.getProperty()) || PRICE_LEVEL.equals(nextReq.getProperty())) continue;
                        SB.append(nextReq.getLabel()).append(": ").append(nextReq.getValue()).append("<br>");
                    }
                    SB.append("has been set successfully.<br><br>");
                    SB.append("Your OrderMate Store ID is <b>").append(this.redbackId).append("</b></html>");
                    OrderMate.LOG.info(SB.toString());
                    Dialogs.showInfoDialog("Cloud Menu Configuration Successful", SB.toString());
                } else {
                    OrderMate.LOG.error("Problem setting online config at HumpBack " + response.getStatus() + " " + entity);
                    Dialogs.showWarningDialog("Cloud Menu Manager Error", "Cloud Menu Manager failed to respond. Please check logs.");
                }
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot contact HumpBack or Error", (Throwable)ex);
                Dialogs.showWarningDialog("Cloud Menu Manager Unreachable", "Cloud Menu Manager could not be reached. Please check logs.");
            }
        }
    }

    private boolean preflightCheck(CloudBackConfig config) {
        if (!config.isEnabled()) {
            Dialogs.showErrorDialog("Not Enabled", "CloudBack for Menus is set to disabled");
            return false;
        }
        if (StringUtils.isEmpty((String)config.getWebConfig().getUrl())) {
            Dialogs.showErrorDialog("Bad URL", "The URL for HumpBack is empty");
            return false;
        }
        if (this.redbackId == 0L) {
            Dialogs.showErrorDialog("Bad RB ID", "The RedBack ID is set to 0 for this store. Cannot proceed.");
            return false;
        }
        return true;
    }
}

