/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.advanced.custompermission;

import au.com.ordermate.application.ApplicationStructure;
import au.com.ordermate.application.GuiApp;
import au.com.ordermate.guicore.task.GUIStateI;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.table.TableCellEditor;
import officemate.components.tableformat.renderers.AutoCompleteComboCellEditor;
import ordermate.database.config.custompermission.CustomPermission;
import ordermate.database.config.custompermission.CustomPermissionHelper;
import ordermate.database.users.PermissionGroup;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.treetable.AbstractMutableTreeTableNode;
import org.jdesktop.swingx.treetable.DefaultMutableTreeTableNode;
import org.jdesktop.swingx.treetable.DefaultTreeTableModel;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableNode;

class StateTreeTable {
    private JXTreeTable treeTable;
    private DefaultTreeTableModel model;
    private static boolean refresh = true;

    public StateTreeTable() {
        this.initStates();
    }

    public JXTreeTable getTable() {
        return this.treeTable;
    }

    private void initStates() {
        DefaultMutableTreeTableNode root = new DefaultMutableTreeTableNode();
        this.model = new DefaultTreeTableModel((TreeTableNode)root);
        ArrayList<String> columnIds = new ArrayList<String>();
        columnIds.add("State Name");
        columnIds.add("Key");
        columnIds.add("Permission");
        this.model.setColumnIdentifiers(columnIds);
        ApplicationStructure structure = GuiApp.getAppComplex().getApplicationStructure();
        ArrayList roots = new ArrayList(structure.getRootStates());
        for (int i = 0; i < roots.size(); ++i) {
            this.addState(this.model, (GUIStateI)roots.get(i), (MutableTreeTableNode)root, i);
        }
        this.treeTable = new JXTreeTable((TreeTableModel)this.model);
        EventList allGroups = GlazedLists.eventList((Collection)PermissionGroup.getPermissionGroups());
        AutoCompleteComboCellEditor editor = new AutoCompleteComboCellEditor(allGroups, true);
        this.treeTable.getColumn(2).setCellEditor((TableCellEditor)((Object)editor));
        this.treeTable.setEditable(true);
    }

    private void addState(DefaultTreeTableModel tableModel, GUIStateI state, MutableTreeTableNode parent, int index) {
        StatePermissionNode node = new StatePermissionNode(state);
        tableModel.insertNodeInto((MutableTreeTableNode)node, parent, index);
        for (int i = 0; i < state.getNumSubStates(); ++i) {
            this.addState(tableModel, (GUIStateI)state.getSubStates().get(i), (MutableTreeTableNode)node, i);
        }
    }

    class StatePermissionNode
    extends AbstractMutableTreeTableNode {
        private final GUIStateI state;
        private static final int PERM_COL = 2;
        private CustomPermission permission;

        StatePermissionNode(GUIStateI yourState) {
            super((Object)yourState, true);
            this.state = yourState;
            this.reloadPermission();
        }

        public int getColumnCount() {
            return 3;
        }

        public Object getValueAt(int col) {
            switch (col) {
                case 0: {
                    return this.state.getName();
                }
                case 1: {
                    return this.state.getStateKey();
                }
                case 2: {
                    return this.permission == null ? "None" : this.permission.getGroup();
                }
            }
            return null;
        }

        public void setValueAt(Object value, int col) {
            if (col == 2) {
                if (value == null || value instanceof String) {
                    this.permission.delete();
                    this.permission = null;
                } else {
                    this.reloadPermission();
                    if (this.permission == null) {
                        this.permission = new CustomPermission("Officemate State", this.state.getStateKey());
                    }
                    this.permission.setGroup((PermissionGroup)value);
                    this.permission.save();
                }
                for (int i = 0; i < this.getChildCount(); ++i) {
                    this.getChildAt(i).setValueAt(value, 2);
                }
                if (refresh) {
                    refresh = false;
                    StateTreeTable.this.treeTable.updateUI();
                    refresh = true;
                }
            }
        }

        public boolean isEditable(int col) {
            return col == 2;
        }

        private void reloadPermission() {
            this.permission = CustomPermissionHelper.getPermission((String)"Officemate State", (String)this.state.getStateKey());
        }
    }
}

