/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.advanced.diamondback;

import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.persistence.propertyaccessor.PropertyAccessor;
import au.com.ordermate.util.image.IconLoader;
import java.awt.event.ActionEvent;
import java.text.SimpleDateFormat;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.table.TableCellEditor;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.EditablePropertyColumnFormat;
import officemate.screens.SQLDatePickerCellEditor;
import ordermate.OrderMate;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.integration.diamondback.DiamondReportConfig;
import ordermate.database.integration.diamondback.DiamondSummaryReportHelper;
import ordermate.database.schedule.Schedule;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;
import ordermate.startup.PushDiamondSummaryReportTask;

public class DiamondReportConfigState
extends AbstractEditableTableState<DiamondReportConfig> {
    private Action pushData = new AbstractAction("Push DiamondBack Report Now", IconLoader.get((String)"/officemate/images/resync.png")){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!DiamondReportConfig.getConfig().isEnabled()) {
                Dialogs.showMessageDialog("Push DiamondBack Report", "Cannot push DiamondBack Report if DiamondBack Report is disabled.");
                return;
            }
            boolean yes = Dialogs.showChoiceDialog("Confirm Manual Push", "Are you sure you wish to push the\nreport to DiamondBack?");
            if (!yes) {
                return;
            }
            PushDiamondSummaryReportTask task = new PushDiamondSummaryReportTask();
            try {
                task.sendDiamondSummaryReport();
                Dialogs.showInfoDialog("Push DiamondBack Report", "DiamondBack Report has been Pushed to DiamondBack successfully");
            }
            catch (Exception ex) {
                OrderMate.LOG.error((Object)ex, (Throwable)ex);
                Dialogs.showInfoDialog("Push DiamondBack Report", "Failed to Push Report to DiamondBack.");
            }
        }
    };
    private Action startPushData = new AbstractAction("Start Schedule Push", IconLoader.get((String)"/ordermate/images/button_cancel.png")){

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean yes = Dialogs.showChoiceDialog("Confirm Start Scheduling", "Are you sure you wish to start scheduling\nto push the report to DiamondBack?");
            if (yes) {
                Schedule schedule = DiamondSummaryReportHelper.getDiamondSummaryReportSchedule();
                schedule.setRecurrence("@tradingday");
                schedule.setSystemState(SystemState.ACTIVE_STATE);
                schedule.save();
                DiamondReportConfigState.this.refresh();
            }
        }
    };
    private Action stopPushData = new AbstractAction("Stop Schedule Push", IconLoader.get((String)"/ordermate/images/button_cancel.png")){

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean yes = Dialogs.showChoiceDialog("Confirm Stop Scheduling", "Are you sure you wish to stop scheduling\nto push the report to DiamondBack?");
            if (yes) {
                Schedule schedule = DiamondSummaryReportHelper.getDiamondSummaryReportSchedule();
                schedule.setRecurrence("");
                schedule.setSystemState(SystemState.ACTIVE_STATE);
                schedule.save();
                DiamondReportConfigState.this.refresh();
            }
        }
    };

    @Override
    protected ObjectEditor<DiamondReportConfig> createObjectEditor() {
        return null;
    }

    public DiamondReportConfigState() {
        this.addAction(this.pushData);
        this.addAction(this.startPushData);
        this.addAction(this.stopPushData);
    }

    @Override
    public String getTypeName() {
        return "DiamondBack Report";
    }

    @Override
    protected TableStateCentralArea<DiamondReportConfig> createCentralArea() {
        ColumnTableFormat format = new ColumnTableFormat(new ColumnFormat[]{new PropertyColumnFormat(DiamondReportConfig.Properties.LABEL), new EditablePropertyColumnFormat(DiamondReportConfig.Properties.ENABLED), new EditablePropertyColumnFormat("Last Push Date", (PropertyAccessor)DiamondReportConfig.Properties.LAST_PUSH_DATE, new SimpleDateFormat("yyyy-MM-dd")).setCustomEditor((TableCellEditor)((Object)new SQLDatePickerCellEditor("yyyy-MM-dd")))});
        return new PersistentObjectTable<DiamondReportConfig>(this.getObjectList(), format);
    }

    @Override
    protected Class<DiamondReportConfig> getDisplayingType() {
        return DiamondReportConfig.class;
    }

    @Override
    public boolean canCreateOrDelete() {
        return false;
    }
}

