/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.advanced.exportsales;

import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.StringUtils;
import ca.odell.glazedlists.EventList;
import java.awt.Component;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.screens.setup.configuration.advanced.exportsales.SalesExportFilterEditor;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.hardware.Terminal;
import ordermate.database.integration.exportsales.ExportSalesIntegration;
import ordermate.database.integration.exportsales.SalesExportItem;
import ordermate.database.inventory.InventoryCategory;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class SalesExportFilterState
extends AbstractEditableTableState<SalesExportItem> {
    SalesExportFilterEditor editor;

    public SalesExportFilterState() {
        super("Sales Export Filter Config", null, "");
        if (SalesExportItem.getAllExportFiltersIncDeleted().isEmpty()) {
            SalesExportItem newObject = new SalesExportItem();
            newObject.setCategories("");
            newObject.setTerminals("");
            newObject.setSalesLocations("");
            ExportSalesIntegration esInt = (ExportSalesIntegration)PersistenceManager.getObject(ExportSalesIntegration.class, (String)Query.select(ExportSalesIntegration.class).equals(ExportSalesIntegration.Properties.ENABLED, 1.0).toString());
            newObject.setExternalLocationID(Long.valueOf(esInt != null ? (long)esInt.getOperationalUnit() : Long.valueOf(0L)));
            newObject.save();
        }
    }

    @Override
    protected ObjectEditor<SalesExportItem> createObjectEditor() {
        this.editor = new SalesExportFilterEditor(Terminal.getAllTerminals(), InventoryCategory.getAllCategories(), SalesLocation.getSalesLocations());
        return this.editor;
    }

    @Override
    protected SalesExportItem createNewObject() {
        SalesExportItem newObject = (SalesExportItem)super.createNewObject();
        newObject.setExternalLocationID(Long.valueOf(0L));
        this.editor.refreshOperationalUnitsList();
        this.editor.refreshEditor();
        return newObject;
    }

    @Override
    protected boolean doEdit(SalesExportItem toEdit) {
        this.editor.refreshOperationalUnitsList();
        return super.doEdit(toEdit);
    }

    @Override
    public void doNewAction() {
        this.editor.refreshOperationalUnitsList();
        super.doNewAction();
    }

    @Override
    public void doEditAction() {
        this.editor.refreshOperationalUnitsList();
        super.doEditAction();
    }

    @Override
    public String getTypeName() {
        return "Sales Export Integration";
    }

    @Override
    protected TableStateCentralArea<SalesExportItem> createCentralArea() {
        PersistentObjectTable<SalesExportItem> table = new PersistentObjectTable<SalesExportItem>(this.getObjectList(), new ColumnTableFormat(new ColumnFormat[]{new PropertyColumnFormat(SalesExportItem.Properties.ID), new PropertyColumnFormat(SalesExportItem.Properties.EXTERNAL_LOCATION_ID), new PropertyColumnFormat(SalesExportItem.Properties.TERMINALS).setCustomRenderer((TableCellRenderer)new IsEmptyValueRenderer()).setCustomRenderer((TableCellRenderer)new TerminalCellRenderer()), new PropertyColumnFormat(SalesExportItem.Properties.CATEGORIES).setCustomRenderer((TableCellRenderer)new IsEmptyValueRenderer()).setCustomRenderer((TableCellRenderer)new CategoryCellRenderer()), new PropertyColumnFormat(SalesExportItem.Properties.SALES_LOCATIONS).setCustomRenderer((TableCellRenderer)new IsEmptyValueRenderer()).setCustomRenderer((TableCellRenderer)new SalesLocationCellRenderer())}));
        table.getTable().getColumn(0).setMaxWidth(80);
        return table;
    }

    @Override
    protected JPanel getControlPanel() {
        JPanel panel = super.getControlPanel();
        return panel;
    }

    @Override
    protected void postRefresh() {
        super.postRefresh();
    }

    @Override
    protected void showCannotSaveDialog() {
        Dialogs.showErrorDialog("Error With Updating Mapping", "Sales from terminals & categories cannot be mapped to more than one area at the same time");
    }

    @Override
    protected Class<SalesExportItem> getDisplayingType() {
        return SalesExportItem.class;
    }

    @Override
    protected boolean isDeleteAllowed(List<SalesExportItem> toDelete) {
        if (this.getObjectList().size() == 1) {
            Dialogs.showErrorDialog("Cannot Delete!", "You must have at least one configuration for Sales Export");
            return false;
        }
        return super.isDeleteAllowed(toDelete);
    }

    @Override
    protected boolean isValidForSaving() {
        this.editor.saveObjectLocal();
        if (SalesExportItem.isDuplicateSectionsSent((SalesExportItem)((SalesExportItem)this.editor.getObject()))) {
            this.refresh();
            return false;
        }
        return true;
    }

    @Override
    public EventList<SalesExportItem> getObjectList() {
        this.setFilterActive(true);
        return super.getObjectList();
    }

    private static final class SalesLocationCellRenderer
    extends DefaultTableCellRenderer {
        private SalesLocationCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                this.setText("All");
            } else {
                this.setText(SalesExportItem.getSalesLocationNameListString((String)value.toString()));
            }
            return this;
        }
    }

    private static final class CategoryCellRenderer
    extends DefaultTableCellRenderer {
        private CategoryCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                this.setText("All");
            } else {
                this.setText(SalesExportItem.getCategoryNameListString((String)value.toString()));
            }
            return this;
        }
    }

    private static final class TerminalCellRenderer
    extends DefaultTableCellRenderer {
        private TerminalCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                this.setText("All");
            } else {
                this.setText(SalesExportItem.getTerminalNameListString((String)value.toString()));
            }
            return this;
        }
    }

    class IsEmptyValueRenderer
    extends DefaultTableCellRenderer {
        IsEmptyValueRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable arg0, Object arg1, boolean arg2, boolean arg3, int arg4, int arg5) {
            super.getTableCellRendererComponent(arg0, arg1, arg2, arg3, arg4, arg5);
            if (arg1 == null || StringUtils.isEmpty((String)arg1.toString())) {
                this.setText("All");
            }
            return this;
        }
    }
}

