/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.advanced.exportsales;

import au.com.ordermate.util.StringUtils;
import ca.odell.glazedlists.GlazedLists;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import officemate.components.AbstractObjectEditor;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.integration.exportsales.ExportSalesHelper;
import ordermate.database.integration.exportsales.ExportSalesIntegration;
import ordermate.database.integration.exportsales.SalesExporterType;
import ordermate.database.schedule.Schedule;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.binding.validators.NotEmptyValidator;
import ordermate.integration.salesexport.TandaExporter;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.Validator;

class SalesExportIntegrationEditor
extends AbstractObjectEditor<ExportSalesIntegration>
implements ActionListener {
    private JComboBox salesExportCombo;
    private JComboBox typeCombo;
    private boolean listen = true;
    private JCheckBox includeTax;
    private JTextField subDomainField;

    public SalesExportIntegrationEditor() {
        this.getBindings().setStrategy(AutoBinding.UpdateStrategy.READ_WRITE);
        this.setupComponents();
    }

    private void setupComponents() {
        FieldPanelBuilder builder = new FieldPanelBuilder();
        this.typeCombo = this.setupComboBox(ExportSalesIntegration.Properties.EXPORTER_TYPE, GlazedLists.eventListOf((Object[])SalesExporterType.values()));
        this.typeCombo.addActionListener(this);
        builder.addRow("Type", (Component)this.typeCombo);
        JCheckBox enabledBox = this.setupCheckBox(ExportSalesIntegration.Properties.ENABLED);
        builder.addRow("Enabled", (Component)enabledBox);
        this.subDomainField = this.setupTextField(ExportSalesIntegration.Properties.SUBDOMAIN, 40);
        builder.addRow("Subdomain", (Component)this.subDomainField);
        builder.addRow("Token", (Component)this.setupTextField(ExportSalesIntegration.Properties.TOKEN, 40));
        builder.addSeparator("Operational");
        builder.addRow("Last Sales Export", (Component)this.setupLabel(ExportSalesIntegration.Properties.LAST_SALES_EXPORT));
        builder.addRow("Last Timesheet Export", (Component)this.setupLabel(ExportSalesIntegration.Properties.LAST_TIMESHEET_EXPORT));
        builder.addRow("Operational Unit", (Component)this.setupIntegerField(ExportSalesIntegration.Properties.OPERATIONAL_UNIT, 10, (Validator)new NotEmptyValidator()));
        builder.addRow("Location", (Component)this.setupIntegerField(ExportSalesIntegration.Properties.LOCATION, 11, (Validator)new NotEmptyValidator()));
        builder.addSeparator("Export Frequency");
        this.salesExportCombo = new JComboBox<ExportFrequencies>(ExportFrequencies.values());
        this.salesExportCombo.addActionListener(this);
        builder.addRow("Sales", (Component)this.salesExportCombo);
        this.includeTax = this.setupCheckBox(ExportSalesIntegration.Properties.INCLUDE_TAX);
        builder.addRow("Include Tax", (Component)this.includeTax);
        this.add(builder.getPanel());
    }

    @Override
    public void setObject(ExportSalesIntegration integration) {
        super.setObject(integration);
        this.listen = false;
        this.salesExportCombo.setSelectedItem((Object)this.matchFrequency(ExportSalesHelper.getSalesExportSchedule().getRecurrence()));
        this.listen = true;
    }

    private ExportFrequencies matchFrequency(String recurrence) {
        if (StringUtils.isEmpty((String)recurrence)) {
            return ExportFrequencies.NONE;
        }
        ExportFrequencies match = ExportFrequencies.CUSTOM;
        for (ExportFrequencies frequency : ExportFrequencies.values()) {
            if (!frequency.recurrence.equals(recurrence)) continue;
            match = frequency;
            break;
        }
        return match;
    }

    private void setFrequency(ExportFrequencies frequency, Schedule schedule) {
        if (ExportFrequencies.CUSTOM.equals((Object)frequency)) {
            String recurrence = JOptionPane.showInputDialog(this, (Object)"Please enter a recurrence:");
            if (recurrence != null) {
                schedule.setRecurrence(recurrence);
                schedule.setSystemState(SystemState.ACTIVE_STATE);
                schedule.save();
            }
        } else {
            schedule.setRecurrence(frequency.recurrence);
            schedule.setSystemState(SystemState.ACTIVE_STATE);
            schedule.save();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.listen) {
            return;
        }
        if (e.getSource() == this.salesExportCombo) {
            ExportFrequencies frequency = (ExportFrequencies)((Object)this.salesExportCombo.getSelectedItem());
            this.setFrequency(frequency, ExportSalesHelper.getSalesExportSchedule());
        } else if (e.getSource() == this.typeCombo) {
            if (SalesExporterType.Deputy.equals(this.typeCombo.getSelectedItem())) {
                this.subDomainField.setText("yourSubdomain");
            } else if (SalesExporterType.Tanda.equals(this.typeCombo.getSelectedItem())) {
                this.subDomainField.setText(TandaExporter.SUBDOMAIN);
            }
        }
    }

    private static enum ExportFrequencies {
        FIVE_MINUTES("Every Five Minutes", "0  */5  *  *  *  ?"),
        HOURLY("Every Hour", "0  1  *  *  *  ?"),
        TRADING_DAY("Every Trading Day", "@tradingday"),
        NONE("No Export", ""),
        CUSTOM("Custom", "");

        private final String label;
        private final String recurrence;

        private ExportFrequencies(String label, String recurrence) {
            this.label = label;
            this.recurrence = recurrence;
        }

        public String toString() {
            return this.label;
        }
    }
}

