/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.advanced.messaging;

import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.message.MessageServer;
import au.com.ordermate.util.image.IconLoader;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.strategy.SaveStrategyFactory;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.EditablePropertyColumnFormat;
import ordermate.OrderMate;
import ordermate.database.message.MailServer;
import ordermate.database.users.AllPermissions;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class MailState
extends AbstractEditableTableState<MailServer> {
    public MailState() {
        super("E-Mail Servers", AllPermissions.GOD_ONLY, "E-Mail Server Settings for messaging");
        this.setSaveStrategy(SaveStrategyFactory.getDeferredSaveStrategy((Refreshable)this));
        this.addAction((Action)((Object)new TestSmtpConnectAction()));
    }

    @Override
    protected boolean canCreateOrDelete() {
        return false;
    }

    @Override
    protected ObjectEditor<MailServer> createObjectEditor() {
        return null;
    }

    @Override
    public String getTypeName() {
        return "E-Mail";
    }

    @Override
    protected TableStateCentralArea<MailServer> createCentralArea() {
        ColumnTableFormat format = new ColumnTableFormat(new ColumnFormat[]{new PropertyColumnFormat(MailServer.Properties.TYPE), new EditablePropertyColumnFormat(MailServer.Properties.HOST), new EditablePropertyColumnFormat(MailServer.Properties.PORT), new EditablePropertyColumnFormat(MailServer.Properties.USERNAME), new EditablePropertyColumnFormat("Password", MailServer.Properties.PASSWORD_RAW), new EditablePropertyColumnFormat("SSL", MailServer.Properties.SSL_CONNECTION), new EditablePropertyColumnFormat("TLS", MailServer.Properties.TLS_CONNECTION)});
        PersistentObjectTable<MailServer> table = new PersistentObjectTable<MailServer>(this.getObjectList(), format);
        return table;
    }

    @Override
    protected Class<MailServer> getDisplayingType() {
        return MailServer.class;
    }

    private class TestSmtpConnectAction
    extends BasicAction {
        TestSmtpConnectAction() {
            super("Test SMTP", (Icon)IconLoader.get((String)"/officemate/images/ok_16.png"), "Test the SMTP connection details.");
        }

        public void actionPerformed(ActionEvent e) {
            Dialogs.showProgressDialog(new AbstractTask(){

                protected int getTotalSubTasks() {
                    return 1;
                }

                protected void performTask() throws Exception {
                    boolean canConnect = false;
                    try {
                        MessageServer.getServer().serversChanged();
                        MessageServer.getServer().connect();
                        canConnect = MessageServer.getServer().isSmtpConnected();
                    }
                    catch (Exception ex) {
                        OrderMate.LOG.error("Cannot connect to smtp server!", (Throwable)ex);
                        canConnect = false;
                    }
                    this.emitProgress();
                    if (canConnect) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                Dialogs.showInfoDialog("Connection Successful", "SMTP Server details appear to be fine.");
                            }
                        });
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                Dialogs.showWarningDialog("Connection Unsuccessful", "SMTP Server could not be contacted! Check logs.");
                            }
                        });
                    }
                }

                public String getName() {
                    return "Connecting to SMTP";
                }
            });
        }
    }
}

