/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.advanced.piggy;

import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.persistence.propertyaccessor.PropertyAccessor;
import au.com.ordermate.util.image.IconLoader;
import java.awt.event.ActionEvent;
import java.text.SimpleDateFormat;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.table.TableCellEditor;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.EditablePropertyColumnFormat;
import officemate.components.tableformat.PopupEditablePropertyColumnFormat;
import officemate.screens.SQLDatePickerCellEditor;
import officemate.screens.setup.configuration.webservice.WebserviceConfigSetupEditor;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.integration.piggy.PiggyConfig;
import ordermate.database.integration.piggy.PiggyPushNonRoomSalesHelper;
import ordermate.database.schedule.Schedule;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;
import ordermate.startup.PiggyPushNonRoomSalesTask;

public class PiggyConfigState
extends AbstractEditableTableState<PiggyConfig> {
    private Action pushData = new AbstractAction("Push Non-Room Sales Now", IconLoader.get((String)"/officemate/images/resync.png")){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!PiggyConfig.getConfig().isEnabled()) {
                Dialogs.showMessageDialog("Push Non-Room Sales", "Cannot push Non Room Sales if Piggy is disabled.");
                return;
            }
            PiggyPushNonRoomSalesTask task = new PiggyPushNonRoomSalesTask();
            try {
                task.sendNonRoomSales();
                Dialogs.showInfoDialog("Push Non-Room Sales", "Non-Room Sales has been Pushed to Piggy Back successfully");
            }
            catch (Exception ex) {
                Dialogs.showInfoDialog("Push Non-Room Sales", "Failed to Push Non-Room Sales to Piggy Back.");
            }
        }
    };
    private Action startPushData = new AbstractAction("Start Schedule Push", IconLoader.get((String)"/ordermate/images/button_cancel.png")){

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean yes = Dialogs.showChoiceDialog("Confirm Start Scheduling", "Are you sure you wish to start scheduling\nto push the non-room charge sales to Piggy Back?");
            if (yes) {
                Schedule schedule = PiggyPushNonRoomSalesHelper.getPushNonRoomSalesSchedule();
                schedule.setRecurrence("@tradingday");
                schedule.setSystemState(SystemState.ACTIVE_STATE);
                schedule.save();
                PiggyConfigState.this.refresh();
            }
        }
    };
    private Action stopPushData = new AbstractAction("Stop Schedule Push", IconLoader.get((String)"/ordermate/images/button_cancel.png")){

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean yes = Dialogs.showChoiceDialog("Confirm Stop Scheduling", "Are you sure you wish to stop scheduling\nto push the non-room charge sales to Piggy Back?");
            if (yes) {
                Schedule schedule = PiggyPushNonRoomSalesHelper.getPushNonRoomSalesSchedule();
                schedule.setRecurrence("");
                schedule.setSystemState(SystemState.ACTIVE_STATE);
                schedule.save();
                PiggyConfigState.this.refresh();
            }
        }
    };

    @Override
    protected ObjectEditor<PiggyConfig> createObjectEditor() {
        return null;
    }

    public PiggyConfigState() {
        this.addAction(this.pushData);
        this.addAction(this.startPushData);
        this.addAction(this.stopPushData);
    }

    @Override
    public String getTypeName() {
        return "Property Management Integration";
    }

    @Override
    protected TableStateCentralArea<PiggyConfig> createCentralArea() {
        ColumnTableFormat format = new ColumnTableFormat(new ColumnFormat[]{new PropertyColumnFormat(PiggyConfig.Properties.LABEL), new EditablePropertyColumnFormat(PiggyConfig.Properties.ENABLED), new PopupEditablePropertyColumnFormat(PiggyConfig.Properties.WEB_CONFIG, new WebserviceConfigSetupEditor(), this), new EditablePropertyColumnFormat("Last Push Date", (PropertyAccessor)PiggyConfig.Properties.LAST_PUSH_DATE, new SimpleDateFormat("yyyy-MM-dd")).setCustomEditor((TableCellEditor)((Object)new SQLDatePickerCellEditor("yyyy-MM-dd")))});
        return new PersistentObjectTable<PiggyConfig>(this.getObjectList(), format);
    }

    @Override
    protected Class<PiggyConfig> getDisplayingType() {
        return PiggyConfig.class;
    }

    @Override
    public boolean canCreateOrDelete() {
        return false;
    }
}

