/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.advanced.salesexport;

import au.com.ordermate.guicore.task.AbstractGuiTask;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import officemate.adminkit.dialogs.Dialogs;
import ordermate.OrderMate;
import ordermate.database.integration.exportsales.ExportSalesHelper;
import ordermate.database.integration.exportsales.ExportSalesIntegration;
import ordermate.database.misc.BusinessInfo;
import ordermate.integration.webservice.RestHelper;

public class TandaDatastreamTask
extends AbstractGuiTask {
    private final Integer TIMEOUT = 10000;

    public String getName() {
        return "Create Tanda Datastream";
    }

    protected int getTotalSubTasks() {
        return 1;
    }

    protected void doGuiTask() throws Exception {
        String storeName = "OrderMate: " + BusinessInfo.getInstance().getName();
        String datastream = "{\r\n\"name\": \"" + storeName + "\",\r\n\"data_interval\": 900\r\n}";
        ExportSalesIntegration integration = ExportSalesHelper.getIntegration();
        String URL2 = "https://" + integration.getSubdomain() + "/api/v2/datastreams";
        RestHelper rest = new RestHelper();
        WebResource resource = rest.getResource(URL2, this.TIMEOUT, this.TIMEOUT);
        boolean fine = false;
        ClientResponse response = null;
        try {
            WebResource.Builder builder = (WebResource.Builder)((WebResource.Builder)resource.header("Authorization", (Object)("Bearer " + integration.getToken())).type("application/json")).accept(new String[]{"application/json"});
            response = (ClientResponse)builder.post(ClientResponse.class, (Object)datastream);
            boolean bl = fine = response.getStatus() / 100 == 2;
            if (!fine) {
                String entity = (String)response.getEntity(String.class);
                OrderMate.LOG.warn("Export of Sales Data to Tanda failed: " + response.getStatus() + " " + entity);
                Dialogs.showErrorDialog("Cannot create datastream", entity);
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot create datastream to Tanda", (Throwable)ex);
            fine = false;
        }
        if (fine && response != null) {
            String entity = null;
            try {
                entity = (String)response.getEntity(String.class);
                String token = "\"id\":";
                int index = entity.indexOf(token);
                if (index > 1) {
                    String id = entity.substring(index + token.length(), entity.indexOf(",", index));
                    id.trim();
                    Integer intId = Integer.valueOf(id);
                    if (intId != null) {
                        integration.setOperationalUnit(intId.intValue());
                        integration.save();
                    }
                }
            }
            catch (Exception ex) {
                OrderMate.LOG.warn("Cannot set the location id: " + response.getStatus() + " " + entity);
                Dialogs.showErrorDialog("Cannot create datastream", entity);
            }
        }
    }
}

