/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.advanced.webresource;

import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.persistence.Executable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.image.IconLoader;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.AbstractObjectEditor;
import officemate.components.ObjectEditorState;
import officemate.components.strategy.SaveStrategyFactory;
import officemate.screens.setup.configuration.advanced.webresource.WebResourceIntegrationEditor;
import ordermate.database.integration.WebResourceIntegration;
import ordermate.database.users.AllPermissions;
import ordermate.services.misc.CallMethodOnClassExecutable;

public class WebResourceIntegrationState
extends ObjectEditorState<WebResourceIntegration> {
    private WebResourceIntegration instance;

    public WebResourceIntegrationState() {
        super("Web Resource Config", AllPermissions.EDIT_TIMESHEET, "Enable and configure timesheet export integration");
        this.setSaveStrategy(SaveStrategyFactory.getDeferredSaveStrategy((Refreshable)this));
        this.instance = WebResourceIntegration.getInstance();
        AbstractAction action = new AbstractAction("Restart", IconLoader.get((String)"/officemate/images/resync.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                Dialogs.showProgressDialog(new RestartServicesTask());
            }
        };
        this.addAction(action);
    }

    @Override
    protected WebResourceIntegration acquireObject() {
        return this.instance;
    }

    @Override
    protected AbstractObjectEditor<WebResourceIntegration> createObjectEditor() {
        return new WebResourceIntegrationEditor();
    }

    class RestartServicesTask
    extends AbstractTask {
        RestartServicesTask() {
        }

        public String getName() {
            return "Restarting Services...";
        }

        protected void performTask() throws Exception {
            CallMethodOnClassExecutable exec = new CallMethodOnClassExecutable("servermate.servlets.jersey.IntegrationWebServer", new String[]{"getInstance", "restart"});
            PersistenceManager.getServerConnection().runSync((Executable)exec);
            this.emitProgress();
        }

        protected int getTotalSubTasks() {
            return -1;
        }
    }
}

