/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.advanced.webresource;

import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.image.IconLoader;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.table.TableCellEditor;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.table.PersistentObjectTable;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.EditablePropertyColumnFormat;
import officemate.components.tableformat.renderers.AutoCompleteComboCellEditor;
import ordermate.database.config.webresource.WebResource;
import ordermate.database.config.webresource.WebResourceUser;
import ordermate.database.config.webresource.WebResourceUserLink;
import ordermate.database.dbconstants.SystemState;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

class WebResourceUserLinkEditor
implements ObjectEditor<WebResourceUser>,
ActionListener {
    private PersistentObjectTable<WebResourceUserLink> linkTable;
    private EventList<WebResourceUserLink> userLinks;
    private WebResourceUser user;
    private JPanel linkPanel;
    private JButton addButton;
    private JButton removeButton;

    WebResourceUserLinkEditor() {
    }

    private void setupComponents() {
        this.userLinks = new BasicEventList();
        ColumnTableFormat format = new ColumnTableFormat(new ColumnFormat[]{new PropertyColumnFormat(WebResourceUserLink.Properties.RESOURCE), new EditablePropertyColumnFormat(WebResourceUserLink.Properties.SYSTEM_STATE).setCustomEditor((TableCellEditor)((Object)new AutoCompleteComboCellEditor(GlazedLists.eventList(SystemState.defaultEditableSystemStates.values()))))});
        this.linkPanel = new JPanel(new BorderLayout());
        this.linkTable = new PersistentObjectTable<WebResourceUserLink>(this.userLinks, format);
        this.linkTable.setPreferredSize(new Dimension(300, 200));
        this.linkPanel.add(this.linkTable, "Center");
        JPanel buttonHolder = new JPanel();
        this.linkPanel.add((Component)buttonHolder, "South");
        this.addButton = this.createButton("Add...", "/ordermate/images/new_icon16.png");
        this.removeButton = this.createButton("Remove", "/ordermate/images/delete_icon16.png");
        buttonHolder.add(this.addButton);
        buttonHolder.add(this.removeButton);
    }

    private JButton createButton(String name, String icon) {
        JButton button = new JButton(name, IconLoader.get((String)icon));
        button.addActionListener(this);
        return button;
    }

    public void saveObject() {
    }

    public void setObject(WebResourceUser toEdit) {
        this.user = toEdit;
        this.refresh();
    }

    private void refresh() {
        EventList<WebResourceUserLink> list = this.linkTable.getEventList();
        list.getReadWriteLock().writeLock().lock();
        list.clear();
        if (this.user != null) {
            list.addAll((Collection)this.user.getLinks());
        }
        list.getReadWriteLock().writeLock().unlock();
    }

    public WebResourceUser getObject() {
        return this.user;
    }

    public boolean isGuiValid() {
        return true;
    }

    public JComponent getComponent() {
        if (this.linkPanel == null) {
            this.setupComponents();
        }
        return this.linkPanel;
    }

    public void revertObject() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.addButton.equals(e.getSource())) {
            this.doAdd();
        } else if (this.removeButton.equals(e.getSource())) {
            this.doRemove();
        }
    }

    private void doAdd() {
        List resources = PersistenceManager.getObjectList(WebResource.class, (String)Query.select(WebResource.class).equals(WebResource.Properties.SECURE, (Object)"1").toString());
        for (WebResourceUserLink link : this.user.getLinks()) {
            resources.remove(link.getResource());
        }
        if (resources.isEmpty()) {
            Dialogs.showInfoDialog("All added", "There are no more Secure Web Resources to add");
        } else {
            Object value = Dialogs.showOptionDialog("Web Resource", "Choose the resource policy to add to this user", resources);
            if (value != null) {
                WebResource chosenResource = (WebResource)value;
                this.getObject().getLinks().add(new WebResourceUserLink(chosenResource, this.user));
                this.refresh();
            }
        }
    }

    private void doRemove() {
        WebResourceUserLink link = this.linkTable.getSelectedObject();
        if (link != null) {
            this.getObject().getLinks().remove(link);
            this.refresh();
        }
    }
}

