/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.adyen;

import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.HtmlUtils;
import au.com.ordermate.util.StringUtils;
import au.com.ordermate.util.image.IconLoader;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.dialogs.OfficeMateGuiHandler;
import officemate.components.AbstractObjectEditor;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.eftpos.EftposType;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.hardware.physical.VirtualEftpos;
import ordermate.database.integration.adyen.AdyenCurrencyCode;
import ordermate.database.integration.adyen.AdyenIntegrationConfig;
import ordermate.database.integration.adyen.AdyenManagementUrlType;
import ordermate.database.users.User;
import ordermate.gui.FieldPanelBuilder;
import ordermate.integration.eftpos.adyen.AdyenUtils;

class AdyenIntegrationEditor
extends AbstractObjectEditor<AdyenIntegrationConfig> {
    private final String OPAY_CASHDRAWER = "Opay Cashdrawer";
    private static User user;
    private static JTextField surchargeRate;
    private static JTextField apiKey;
    private static JComboBox currencyCode;
    private static JComboBox managementUrl;
    private JComboBox cashdrawers;
    private EventList<CashDrawer> cdList;

    @Override
    public void refresh() {
        AdyenIntegrationConfig.refreshReference();
    }

    public static void setUser(User u) {
        user = u;
        boolean isSuperUser = AdyenUtils.isTerminalSettingsEditAllowed((User)user);
        surchargeRate.setEnabled(isSuperUser);
        apiKey.setEnabled(isSuperUser);
        apiKey.setVisible(isSuperUser);
    }

    public AdyenIntegrationEditor(User currentUser) {
        user = currentUser;
        this.setLayout(new FlowLayout(0));
    }

    @Override
    protected void init() {
        FieldPanelBuilder builder = new FieldPanelBuilder(new JPanel(new FlowLayout(0)));
        builder.addRow("Active?:", (Component)this.setupCheckBox(AdyenIntegrationConfig.Properties.CONFIGURED));
        builder.addRow("Merchant Account:", (Component)this.setupTextField(AdyenIntegrationConfig.Properties.STORE_IDENTIFIER, 50));
        apiKey = this.setupTextField(AdyenIntegrationConfig.Properties.API_CREDENTIAL, 50);
        builder.addRow("API KEY:", (Component)apiKey);
        managementUrl = this.setupComboBox(AdyenIntegrationConfig.Properties.MANAGEMENT_URL, GlazedLists.eventList(AdyenManagementUrlType.register.values()));
        currencyCode = this.setupComboBox(AdyenIntegrationConfig.Properties.CURRENCY_CODE, GlazedLists.eventList(AdyenCurrencyCode.register.values()));
        builder.addRow("Currency Code:", (Component)currencyCode);
        builder.addRow("Checkout Prefix:", (Component)this.setupTextField(AdyenIntegrationConfig.Properties.CHECKOUT_PREFIX, 50));
        JTextField endpoint = this.setupTextField(AdyenIntegrationConfig.Properties.LIVE_ENDPOINT, 50);
        endpoint.setEditable(false);
        builder.addRow("Live Endpoint:", (Component)endpoint);
        surchargeRate = this.setupTextField(AdyenIntegrationConfig.Properties.SURCHARGE_RATE, 10);
        builder.addRow("Surcharge Rate", (Component)surchargeRate);
        this.cdList = GlazedLists.eventList((Collection)CashDrawer.getAllCashDrawers());
        this.cashdrawers = this.setupComboBox(AdyenIntegrationConfig.Properties.CASHDRAWER, this.cdList);
        builder.addRow("OPay Cashdrawer", (Component)this.cashdrawers);
        JButton viewGuidesBtn = new JButton("View Setup Guides");
        viewGuidesBtn.setToolTipText("View Setup Guides for Oolio Terminals");
        viewGuidesBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Dialogs.showLinkDialog("Oolio Setup", HtmlUtils.html((String)"Click the link to open up the oolio setup documentation"), new URI("https://docs.adyen.com/point-of-sale/user-manuals"), "Oolio Docs");
                }
                catch (Exception ex) {
                    OrderMate.LOG.error("URISyntaxException while grabbing Oolio URI!", (Throwable)ex);
                }
            }
        });
        JButton addEftpos = new JButton("Add Eftpos");
        addEftpos.setToolTipText("View Setup Guides for Oolio Terminals");
        addEftpos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdyenIntegrationEditor.this.saveTerminalToEftpos();
            }
        });
        JPanel holder = new JPanel();
        holder.add(viewGuidesBtn);
        holder.add(addEftpos);
        builder.addRow((Component)holder);
        this.add(builder.getPanel());
    }

    private void gotTrackingEditorChanged() {
        this.objectEdited.emit();
    }

    @Override
    public void setObject(AdyenIntegrationConfig toEdit) {
        AdyenIntegrationConfig.refreshReference();
        toEdit = AdyenIntegrationConfig.getInstance();
        if (currencyCode.getSelectedItem() != null) {
            toEdit.setLiveEndpoint(((AdyenCurrencyCode)currencyCode.getSelectedItem()).getUrl());
            toEdit.setCurrencyCode((AdyenCurrencyCode)currencyCode.getSelectedItem());
        }
        if (managementUrl.getSelectedItem() != null) {
            toEdit.setManagementUrl((AdyenManagementUrlType)managementUrl.getSelectedItem());
        }
        if (!StringUtils.isEmpty((String)surchargeRate.getText())) {
            toEdit.setSurchargeRate(Double.valueOf(surchargeRate.getText()));
        }
        super.setObject(toEdit);
    }

    private final CashDrawer selectTerminal() {
        ArrayList terminals = new ArrayList(CashDrawer.getAllCashDrawers());
        if (terminals.isEmpty()) {
            Dialogs.showInfoDialog("No Cash Drawers", "There are no CashDrawers to assign");
            return null;
        }
        return (CashDrawer)Dialogs.showOptionDialog("Which Cashdrawer?", "Please select a Cashdrawer to Assign.", terminals);
    }

    protected void saveTerminalToEftpos() {
        String terminalID = new OfficeMateGuiHandler().getStringInput("Serial Number?", "");
        if (terminalID == null || StringUtils.isEmpty((String)terminalID.trim())) {
            Dialogs.showErrorDialog("Error Saving Terminal", "Terminal ID is Empty");
            return;
        }
        terminalID = terminalID.trim();
        List ls = PersistenceManager.getObjectList(VirtualEftpos.class, (String)Query.select(VirtualEftpos.class).active(VirtualEftpos.class).equals(VirtualEftpos.Properties.EFTPOS_TYPE, (Object)EftposType.ADYEN).equals(VirtualEftpos.Properties.TERMINAL_ID, (Object)terminalID).toString());
        if (ls.size() > 0) {
            Dialogs.showErrorDialog("Error Saving Terminal", "Terminal ID found in current Eftpos Configuration");
            return;
        }
        CashDrawer selection = this.selectTerminal();
        if (selection == null) {
            Dialogs.showErrorDialog("Error Saving Terminal", "No Cashdrawer assigned to eftpos");
            return;
        }
        if (!Dialogs.showChoiceDialog("Confirm Terminal", "S/N: " + terminalID + "\nCD: " + selection.getLabel())) {
            return;
        }
        VirtualEftpos newEftpos = new VirtualEftpos();
        newEftpos.setEftposType(EftposType.ADYEN);
        newEftpos.setLabel("Oolio-" + terminalID);
        newEftpos.setCashDrawer(selection);
        newEftpos.setIpAddress("https://terminal-api-live-au.adyen.com/sync");
        newEftpos.setEnableTip(false);
        newEftpos.setPrintReceipts(false);
        newEftpos.setTerminalId(terminalID);
        newEftpos.setMerchantId(AdyenIntegrationConfig.getInstance().getStoreIdentifier());
        newEftpos.setSupportsCardAcq(false);
        newEftpos.save();
        Dialogs.showInfoDialog("Successful", "Eftpos added to configuration successfully");
    }

    @Override
    public void saveObject() {
        if (AdyenUtils.isTerminalSettingsEditAllowed((User)user)) {
            if (Dialogs.showChoiceDialog("Please Confirm Action", "Saving this configuration will cause payment types to be overwritten, would you like to proceed?")) {
                try {
                    CashDrawer c = CashDrawer.getByName((String)"Opay Cashdrawer");
                    if (c == null) {
                        c = new CashDrawer();
                        c.setLabel("Opay Cashdrawer");
                        c.setTerminals(Arrays.asList(Terminal.getServerMateTerminal()));
                        c.setPortType("None");
                        c.setPort("9100");
                        c.setPortSpeed(9600);
                        c.setUserPayable(false);
                        c.setFlowControl("None");
                        c.setKickerType("Terminal");
                        c.save();
                        this.cdList.add((Object)c);
                    }
                    if (((AdyenIntegrationConfig)this.getObject()).getCashdrawer() == null) {
                        this.cashdrawers.setSelectedItem(c);
                        ((AdyenIntegrationConfig)this.getObject()).setCashdrawer(c);
                    }
                    OrderMate.LOG.info("Attempting To Save payment types to " + ((AdyenIntegrationConfig)this.getObject()).getSurchargeRate().toString() + "%");
                    super.saveObject();
                    AdyenUtils.revalidateSurchargeAmounts((double)((AdyenIntegrationConfig)this.getObject()).getSurchargeRate());
                }
                catch (Exception ex) {
                    OrderMate.LOG.error((Object)ex);
                }
            }
        } else {
            super.saveObject();
        }
        this.setObject(AdyenIntegrationConfig.getInstance());
    }

    private class AddAdyenTerminalAction
    extends BasicAction {
        AddAdyenTerminalAction() {
            super("Add Terminal", (Icon)IconLoader.get((String)"/ordermate/images/button_add.png"), "Creates a new terminal inside Eftpos Config");
        }

        public void actionPerformed(ActionEvent e) {
            AdyenIntegrationEditor.this.saveTerminalToEftpos();
        }
    }
}

