/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.adyen;

import au.com.ordermate.xmlintegration.adyen.AdyenGratuities;
import au.com.ordermate.xmlintegration.adyen.AdyenSurcharge;
import au.com.ordermate.xmlintegration.adyen.AdyenTerminalSettingsMessage;
import com.assemblypayments.spi.model.Secrets;
import com.assemblypayments.spi.model.SpiStatus;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import officemate.adminkit.dialogs.Dialogs;
import officemate.screens.setup.configuration.adyen.AdyenSurchargeEditor;
import ordermate.OrderMate;
import ordermate.database.hardware.physical.VirtualEftpos;
import ordermate.database.integration.adyen.AdyenIntegrationConfig;
import ordermate.gui.FieldPanelBuilder;
import ordermate.integration.eftpos.adyen.AdyenIntegrationProcessor;
import ordermate.integration.eftpos.manager.EftposToolkit;

public class AdyenTerminalSettingsScreen {
    private final VirtualEftpos eftpos;
    private Secrets secrets = null;
    private SpiStatus spiStatus = SpiStatus.UNPAIRED;
    private JPanel guiPanel;
    JCheckBox askConfSur;
    private EftposToolkit toolkit;
    private final int sizeX = 700;
    private final int sizeY = 350;
    private AdyenTerminalSettingsMessage terminalSettings;

    public AdyenTerminalSettingsScreen(VirtualEftpos eft, EftposToolkit kit) {
        this.eftpos = eft;
        this.toolkit = kit;
        this.guiPanel = new JPanel(new BorderLayout());
        this.guiPanel.setPreferredSize(new Dimension(700, 350));
    }

    public void initialize() {
        try {
            String endpoint = AdyenIntegrationConfig.getInstance().getManagementUrlString() + "terminals/" + this.eftpos.getTerminalId() + "/terminalSettings";
            this.terminalSettings = AdyenIntegrationProcessor.getInstance().getTerminalSettings(endpoint);
            if (this.terminalSettings.getGratuities() == null) {
                this.terminalSettings.setGratuities(new AdyenGratuities[0]);
            }
            if (this.terminalSettings.getSurcharge() == null) {
                this.terminalSettings.setSurcharge(new AdyenSurcharge());
            }
            this.guiPanel.add((Component)new AdyenTerminalPanel(this.terminalSettings), "Center");
            this.toolkit.getGuiHandler().displayBlockingDialog(this.guiPanel);
        }
        catch (Exception ex) {
            OrderMate.LOG.error(ex.getMessage(), (Throwable)ex);
        }
    }

    private class AdyenTerminalPanel
    extends JPanel
    implements ActionListener {
        AdyenTerminalPanel(AdyenTerminalSettingsMessage msg) {
            this.setupComponents(msg);
        }

        private void setupComponents(AdyenTerminalSettingsMessage msg) {
            this.setLayout(new BorderLayout());
            FieldPanelBuilder builder = new FieldPanelBuilder();
            JTabbedPane tab = new JTabbedPane();
            tab.setSize(700, 350);
            tab.add("Device Info", this.deviceInfoPanel(msg));
            tab.add("Surcharges", new AdyenSurchargeEditor(msg.getSurcharge(), AdyenTerminalSettingsScreen.this.terminalSettings));
            this.add(tab);
        }

        private JPanel deviceInfoPanel(AdyenTerminalSettingsMessage msg) {
            FieldPanelBuilder builder = new FieldPanelBuilder();
            JTextField terminalIDField = new JTextField(20);
            terminalIDField.setText(msg.getSignature().getDeviceName());
            terminalIDField.setEditable(false);
            builder.addRow("Device: ", (Component)terminalIDField);
            JTextField patField = new JTextField(50);
            patField.setText(msg.getOPI().getPayAtTableURL());
            patField.setEditable(false);
            builder.addRow("Pay At Table Url: ", (Component)patField);
            JButton OKButton = new JButton("Save Settings");
            OKButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AdyenTerminalSettingsScreen.this.terminalSettings.getSurcharge().setAskConfirmation(AdyenTerminalSettingsScreen.this.askConfSur.isSelected());
                    String endpoint = AdyenIntegrationConfig.getInstance().getManagementUrlString() + "terminals/" + AdyenTerminalSettingsScreen.this.eftpos.getTerminalId() + "/terminalSettings";
                    boolean r = AdyenIntegrationProcessor.getInstance().patchTerminalSettings(AdyenTerminalSettingsScreen.this.terminalSettings, endpoint);
                    if (!r) {
                        Dialogs.showErrorDialog("Update Failed", "Terminal Settings Update Failed, Check Connection");
                    } else {
                        Dialogs.showInfoDialog("Update Success", "Terminal Settings Updated Successfully");
                    }
                }
            });
            return builder.getPanel();
        }

        @Override
        public void actionPerformed(ActionEvent event) {
        }
    }
}

