/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.adyen;

import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.image.IconLoader;
import au.com.ordermate.xmlintegration.adyen.AdyenTerminalData;
import au.com.ordermate.xmlintegration.adyen.AdyenTerminalsMessage;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.table.AbstractTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.screens.setup.configuration.adyen.AdyenTerminalsTableFormat;
import ordermate.OrderMate;
import ordermate.database.hardware.eftpos.EftposType;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.hardware.physical.VirtualEftpos;
import ordermate.database.integration.adyen.AdyenIntegrationConfig;
import ordermate.integration.eftpos.adyen.AdyenIntegrationProcessor;

public class AdyenTerminalsTable
extends AbstractTableState<AdyenTerminalData> {
    private AdyenTerminalsMessage terminalData;
    private EventList<AdyenTerminalData> termConfig;
    private PersistentObjectTable<AdyenTerminalData> termConfigTable;

    @Override
    public void refresh() {
        this.refreshTerminals();
    }

    @Override
    protected void init() {
        super.init();
        this.addSelectionDependentAction((Action)((Object)new AddTerminalAction()));
    }

    private void refreshTerminals() {
        AdyenIntegrationConfig.refreshReference();
        String endpoint = AdyenIntegrationConfig.getInstance().getManagementUrlString() + "/terminals";
        this.terminalData = AdyenIntegrationProcessor.getInstance().getAllTerminals(endpoint);
        this.termConfig.clear();
        if (this.terminalData != null && this.terminalData.getData() != null) {
            this.termConfig.addAll(Arrays.asList(this.terminalData.getData()));
        }
    }

    public AdyenTerminalsTable() {
        super("Oolio Terminals", null, "");
        try {
            this.refreshTerminals();
        }
        catch (Exception ex) {
            OrderMate.LOG.info(ex.getMessage());
            this.terminalData = new AdyenTerminalsMessage();
            this.terminalData.setData(new AdyenTerminalData[0]);
            this.termConfig = new BasicEventList();
            this.termConfig.addAll(Arrays.asList(this.terminalData.getData()));
        }
    }

    public List<AdyenTerminalData> getTerminalModes() {
        return new ArrayList<AdyenTerminalData>((Collection<AdyenTerminalData>)this.termConfig);
    }

    @Override
    protected TableStateCentralArea<AdyenTerminalData> createCentralArea() {
        this.termConfigTable = new PersistentObjectTable<AdyenTerminalData>(this.termConfig, new AdyenTerminalsTableFormat(this.terminalData));
        this.termConfigTable.setSize(this.termConfigTable.getTable().getSize());
        this.termConfigTable.setPreferredSize(this.termConfigTable.getTable().getSize());
        return this.termConfigTable;
    }

    @Override
    protected Class<AdyenTerminalData> getDisplayingType() {
        return AdyenTerminalData.class;
    }

    private final CashDrawer selectTerminal() {
        ArrayList terminals = new ArrayList(CashDrawer.getAllCashDrawers());
        if (terminals.isEmpty()) {
            Dialogs.showInfoDialog("No Cash Drawers", "There are no CashDrawers to assign");
            return null;
        }
        return (CashDrawer)Dialogs.showOptionDialog("Which Cashdrawer?", "Please select a Cashdrawer to Assign.", terminals);
    }

    protected void saveTerminalToEftpos() {
        AdyenTerminalData toSave = (AdyenTerminalData)this.getCentralArea().getSelectedObject();
        if (toSave == null) {
            throw new IllegalArgumentException("No terminal selected, cannot save");
        }
        if (!toSave.isAssigned()) {
            Dialogs.showErrorDialog("Error Saving Terminal", "Terminal has not been assigned, check with Oolio");
            return;
        }
        List ls = PersistenceManager.getObjectList(VirtualEftpos.class, (String)Query.select(VirtualEftpos.class).active(VirtualEftpos.class).equals(VirtualEftpos.Properties.EFTPOS_TYPE, (Object)EftposType.ADYEN).equals(VirtualEftpos.Properties.TERMINAL_ID, (Object)toSave.getID()).toString());
        if (ls.size() > 0) {
            Dialogs.showErrorDialog("Error Saving Terminal", "Terminal ID found in current Eftpos Configuration");
            return;
        }
        CashDrawer selection = this.selectTerminal();
        if (selection == null) {
            Dialogs.showErrorDialog("Error Saving Terminal", "No Cashdrawer assigned to eftpos");
            return;
        }
        VirtualEftpos newEftpos = new VirtualEftpos();
        newEftpos.setEftposType(EftposType.ADYEN);
        newEftpos.setLabel("Oolio-" + toSave.getID());
        newEftpos.setCashDrawer(selection);
        newEftpos.setIpAddress("https://terminal-api-live-au.adyen.com/sync");
        newEftpos.setEnableTip(true);
        newEftpos.setPrintReceipts(true);
        newEftpos.setTerminalId(toSave.getID());
        newEftpos.setMerchantId(AdyenIntegrationConfig.getInstance().getStoreIdentifier());
        newEftpos.setSupportsCardAcq(false);
        newEftpos.save();
        Dialogs.showInfoDialog("Successful", "Eftpos added to configuration successfully");
    }

    private class AddTerminalAction
    extends BasicAction {
        AddTerminalAction() {
            super("Add To OfficeMate", (Icon)IconLoader.get((String)"/ordermate/images/button_add.png"), "Creates a new terminal as a copy of the selected one.");
        }

        public void actionPerformed(ActionEvent e) {
            AdyenTerminalsTable.this.saveTerminalToEftpos();
        }
    }
}

