/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.bartabs;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.Component;
import java.util.Collection;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.components.AbstractObjectEditor;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.integration.bartabs.BarTabsConfiguration;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.binding.validators.NotEmptyValidator;
import org.jdesktop.beansbinding.Validator;

public class BarTabsConfigurationEditor
extends AbstractObjectEditor<BarTabsConfiguration> {
    private JTextField nameField;
    private JTextField vendorIdField;
    private JTextField payBtnTxtField;
    private JTextField payBtnIconField;
    private JTextField serverAddressField;
    private JComboBox financeUnitComboBox;
    private JTextField secretKeyField;
    private JCheckBox enabledCheckBox;
    private final EventList<FinanceUnit> financeUnits = GlazedLists.eventList((Collection)FinanceUnit.getAllUnits());

    public BarTabsConfigurationEditor() {
        this.setupComponents();
    }

    private void setupComponents() {
        FieldPanelBuilder builder = new FieldPanelBuilder();
        this.nameField = this.setupTextField(BarTabsConfiguration.Properties.NAME, 25, (Validator)new NotEmptyValidator());
        builder.addRow("Name", (Component)this.nameField);
        this.vendorIdField = this.setupTextField(BarTabsConfiguration.Properties.VENDOR_ID, 25, (Validator)new NotEmptyValidator());
        builder.addRow("Vendor ID", (Component)this.vendorIdField);
        this.payBtnTxtField = this.setupTextField(BarTabsConfiguration.Properties.PAY_BUTTON_TXT, 25);
        builder.addRow("Pay Button Label", (Component)this.payBtnTxtField);
        this.payBtnIconField = this.setupTextField(BarTabsConfiguration.Properties.ICON, 50);
        builder.addRow("Pay Button Icon", (Component)this.payBtnIconField);
        this.serverAddressField = this.setupTextField(BarTabsConfiguration.Properties.URL, 50);
        builder.addRow("Server Address", (Component)this.serverAddressField);
        this.financeUnitComboBox = this.setupComboBox(BarTabsConfiguration.Properties.FINANCE_UNIT, this.financeUnits);
        builder.addRow("Pay Off Finance Unit", (Component)this.financeUnitComboBox);
        this.secretKeyField = this.setupTextField(BarTabsConfiguration.Properties.SECRET_KEY, 50);
        builder.addRow("Secret Key", (Component)this.secretKeyField);
        this.enabledCheckBox = this.setupCheckBox(BarTabsConfiguration.Properties.ENABLED);
        builder.addRow("Enabled", (Component)this.enabledCheckBox);
        this.add(builder.getPanel());
    }

    @Override
    public void refresh() {
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.financeUnits, FinanceUnit.getAllUnits());
        super.refresh();
    }

    @Override
    public void setObject(BarTabsConfiguration toEdit) {
        super.setObject(toEdit);
        this.setupComponentEnabledStatus();
    }

    private void setupComponentEnabledStatus() {
        if (this.getObject() != null && ((BarTabsConfiguration)this.getObject()).isFullIntegration()) {
            this.nameField.setEnabled(false);
            this.vendorIdField.setEnabled(false);
            this.payBtnTxtField.setEnabled(false);
            this.payBtnIconField.setEnabled(false);
            this.serverAddressField.setEnabled(true);
            this.financeUnitComboBox.setEnabled(false);
            this.secretKeyField.setEnabled(true);
            this.enabledCheckBox.setEnabled(true);
        } else {
            this.nameField.setEnabled(true);
            this.vendorIdField.setEnabled(true);
            this.payBtnTxtField.setEnabled(true);
            this.payBtnIconField.setEnabled(true);
            this.serverAddressField.setEnabled(true);
            this.financeUnitComboBox.setEnabled(true);
            this.secretKeyField.setEnabled(true);
            this.enabledCheckBox.setEnabled(true);
        }
    }
}

