/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.courses;

import au.com.ordermate.gui.ObjectEditor;
import ca.odell.glazedlists.GlazedLists;
import java.util.Arrays;
import java.util.List;
import javax.swing.table.TableCellEditor;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.strategy.SaveStrategyFactory;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.EditablePropertyColumnFormat;
import officemate.components.tableformat.renderers.AutoCompleteComboCellEditor;
import officemate.components.tableformat.renderers.SequenceEditor;
import ordermate.database.course.CourseHoldStrategy;
import ordermate.database.gui.configmanager.GuiConfigManager;
import ordermate.database.misc.Course;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.users.AllPermissions;
import ordermate.reports.table.ColumnFormat;

public class CoursesState
extends AbstractEditableTableState {
    public CoursesState() {
        super("Courses", AllPermissions.ACCESS_COURSES, "View, create and modify courses.");
        this.setSaveStrategy(SaveStrategyFactory.getInstantSaveStrategy(1L));
    }

    public ObjectEditor createObjectEditor() {
        return null;
    }

    @Override
    public String getTypeName() {
        return "Course";
    }

    @Override
    public TableStateCentralArea createCentralArea() {
        PersistentObjectTable table = new PersistentObjectTable(this.getObjectList(), new ColumnTableFormat(new ColumnFormat[]{new EditablePropertyColumnFormat(Course.Properties.SEQUENCE).setCustomEditor((TableCellEditor)((Object)new SequenceEditor())), new EditablePropertyColumnFormat(Course.Properties.NAME), new EditablePropertyColumnFormat(Course.Properties.DEFAULT_COURSE), new EditablePropertyColumnFormat(Course.Properties.COURSE_HOLD_STRATEGY).setCustomEditor((TableCellEditor)((Object)new AutoCompleteComboCellEditor(GlazedLists.eventList(Arrays.asList(CourseHoldStrategy.values())))))}));
        return table;
    }

    @Override
    public Class getDisplayingType() {
        return Course.class;
    }

    protected Object createNewObject() {
        return GuiConfigManager.addCourseGuiConfigs((Course)((Course)super.createNewObject()));
    }

    protected boolean isDeleteAllowed(List toDelete) {
        if (toDelete.contains(Course.getDefault())) {
            Dialogs.showErrorDialog("Cannot Delete Course", "You must assign a new default course before delting this one");
            return false;
        }
        return super.isDeleteAllowed(toDelete);
    }

    public void gotObjectDeleted(Object deletedObject) {
        super.gotObjectDeleted(GuiConfigManager.deleteCourseGuiConfigs((Course)((Course)deletedObject)));
    }

    public void gotObjectEdited(Object editedObject) {
        GuiConfigManager.renameCourseGuiConfigs((Course)((Course)editedObject));
        super.gotObjectEdited(editedObject);
        this.refresh();
    }

    @Override
    public boolean checkUpdate() {
        if (super.checkUpdate()) {
            SystemCurrentInfo.setMenuUpdate((String)"Courses configuration changed");
            return true;
        }
        return false;
    }
}

