/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.deliveryzones;

import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.pager.Pager;
import au.com.ordermate.search.pager.PagerModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.TableCellEditor;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.strategy.SaveStrategyFactory;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.EditablePropertyColumnFormat;
import officemate.components.tableformat.renderers.AutoCompleteComboCellEditor;
import officemate.screens.setup.configuration.deliveryzones.StreetDirectoryReferenceEditor;
import officemate.screens.setup.configuration.deliveryzones.StreetDirectoryReferenceSearch;
import ordermate.database.delivery.StreetDirectoryReference;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class StreetZoningState
extends AbstractEditableTableState<StreetDirectoryReference> {
    private final PagerModel listPager = new PagerModel();
    private StreetDirectoryReferenceSearch search;
    private JCheckBox groupBox;
    StreetDirectoryReferenceEditor streetDirectoryReferenceEditor;

    public StreetZoningState() {
        super("Street Zoning", null, "Assign streets to delivery zones");
        this.setSaveStrategy(SaveStrategyFactory.getInstantSaveStrategy(0L));
        this.streetDirectoryReferenceEditor = new StreetDirectoryReferenceEditor();
    }

    @Override
    public void init() {
        if (this.initCalled) {
            return;
        }
        this.search = new StreetDirectoryReferenceSearch();
        this.search.usePagedObjectQueryRefreshStrategy((Pager)this.listPager);
        this.groupBox = new JCheckBox();
        this.groupBox.setName("Group On Suburb");
        this.groupBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StreetZoningState.this.groupOnSuburb(StreetZoningState.this.groupBox.isSelected());
            }
        });
        JPanel eastPanel = new JPanel();
        JLabel groupBySuburb = new JLabel("Group on Suburb");
        groupBySuburb.setLabelFor(this.groupBox);
        eastPanel.add(groupBySuburb);
        eastPanel.add(this.groupBox);
        this.search.getSearchPanel().add((Component)eastPanel, "East");
        super.init();
        this.addSelectionDependentAction(((PersistentObjectTable)this.getCentralArea()).getEditMultipleAction());
        this.addPageControl(this.listPager);
    }

    @Override
    protected ObjectEditor<StreetDirectoryReference> createObjectEditor() {
        return this.streetDirectoryReferenceEditor;
    }

    @Override
    public String getTypeName() {
        return "Street Directory Zones";
    }

    @Override
    protected TableStateCentralArea<StreetDirectoryReference> createCentralArea() {
        PersistentObjectTable<StreetDirectoryReference> table = new PersistentObjectTable<StreetDirectoryReference>(this.getObjectList(), new ColumnTableFormat(new ColumnFormat[]{new PropertyColumnFormat("Suburb", StreetDirectoryReference.Properties.SUBURB), new PropertyColumnFormat("Street", StreetDirectoryReference.Properties.STREET_NAME), new PropertyColumnFormat("Type", StreetDirectoryReference.Properties.STREET_TYPE), new PropertyColumnFormat("Post Code", StreetDirectoryReference.Properties.POSTCODE), new PropertyColumnFormat("Street Dir. Ref", StreetDirectoryReference.Properties.GRID_POSITION), new EditablePropertyColumnFormat("Zone", StreetDirectoryReference.Properties.ZONE).setCustomEditor((TableCellEditor)((Object)new AutoCompleteComboCellEditor(this.search.getZones(), true)))}));
        table.setPropertiesToBulkExclude(new PropertiedObject.Property[]{StreetDirectoryReference.Properties.SUBURB, StreetDirectoryReference.Properties.STREET_NAME, StreetDirectoryReference.Properties.STREET_TYPE, StreetDirectoryReference.Properties.POSTCODE, StreetDirectoryReference.Properties.GRID_POSITION});
        return table;
    }

    @Override
    protected StreetDirectoryReference createNewObject() {
        StreetDirectoryReference streetDirectoryReference = (StreetDirectoryReference)super.createNewObject();
        streetDirectoryReference.setSystemState("ACTIVE");
        return streetDirectoryReference;
    }

    @Override
    protected Class<StreetDirectoryReference> getDisplayingType() {
        return StreetDirectoryReference.class;
    }

    @Override
    protected OfficeMateObjectSearch<StreetDirectoryReference> createSearchPanelFactory() {
        return this.search;
    }

    @Override
    protected boolean canCreateOrDelete() {
        return true;
    }

    protected void groupOnSuburb(boolean selected) {
        ((PersistentObjectTable)this.getCentralArea()).groupOn(selected ? "Suburb" : null, new String[0]);
    }
}

