/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.docket.grouping;

import au.com.ordermate.glazedlists.GlazedListUtils;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.propertyaccessor.PropertyAccessorVendor;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.Component;
import java.util.Collection;
import javax.swing.JComponent;
import officemate.components.AbstractObjectEditor;
import officemate.screens.setup.configuration.docket.PropertySelector;
import ordermate.database.hardware.DocketGrouping;
import ordermate.database.hardware.DocketSorting;
import ordermate.database.hardware.GroupingHeaderType;
import ordermate.database.misc.action.ConfigAction;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.binding.validators.NotEmptyValidator;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.beansbinding.Validator;

class DocketGroupingEditor
extends AbstractObjectEditor<DocketGrouping> {
    private EventList<DocketSorting> sortings;

    DocketGroupingEditor() {
        this.setupComponents();
    }

    private void setupComponents() {
        this.sortings = new BasicEventList();
        FieldPanelBuilder builder = new FieldPanelBuilder();
        builder.addRow("Label", (Component)this.setupTextField(ConfigAction.Properties.LABEL, 20, (Validator)new NotEmptyValidator()));
        builder.addRow("Group 1", (Component)this.createGroupingCombo(DocketGrouping.Properties.GROUP_1));
        builder.addRow("Group 2", (Component)this.createGroupingCombo(DocketGrouping.Properties.GROUP_2));
        builder.addRow("Group 3", (Component)this.createGroupingCombo(DocketGrouping.Properties.GROUP_3));
        builder.addRow("Group 4", (Component)this.createGroupingCombo(DocketGrouping.Properties.GROUP_4));
        builder.addRow("Group 5", (Component)this.createGroupingCombo(DocketGrouping.Properties.GROUP_5));
        EventList types = GlazedLists.eventListOf((Object[])GroupingHeaderType.values());
        builder.addRow("Header 1", (Component)this.setupComboBox(DocketGrouping.Properties.HEADER_1, types));
        builder.addRow("Header 2", (Component)this.setupComboBox(DocketGrouping.Properties.HEADER_2, types));
        builder.addRow("Header 3", (Component)this.setupComboBox(DocketGrouping.Properties.HEADER_3, types));
        builder.addRow("Header 4", (Component)this.setupComboBox(DocketGrouping.Properties.HEADER_4, types));
        builder.addRow("Header 5", (Component)this.setupComboBox(DocketGrouping.Properties.HEADER_5, types));
        builder.addRow("Default Sorting", (Component)this.setupComboBox(DocketGrouping.Properties.DEFAULT_SORTING, this.sortings));
        this.objectEdited.connect((Object)this, "saveObject");
        this.add(builder.getPanel());
    }

    @Override
    public void setObject(DocketGrouping grouping) {
        GlazedListUtils.setAsList(this.sortings, (Collection)PersistenceManager.getObjectList(DocketSorting.class, (String)Query.select(DocketSorting.class).toString()));
        super.setObject(grouping);
    }

    @Override
    public void saveObject() {
        super.saveObject();
    }

    private JComponent createGroupingCombo(PropertiedObject.Property prop) {
        PropertyAccessorVendor vendor = DocketGrouping.getVendor();
        PropertySelector selector = new PropertySelector(vendor);
        Binding binding = this.getBindings().createBinding(AutoBinding.UpdateStrategy.READ_WRITE, (Property)BeanProperty.create((String)prop.getName()), (Object)selector, (Property)BeanProperty.create((String)"value"));
        return selector;
    }
}

